/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.feature;

import java.util.List;
import javax.xml.ws.WebServiceFeature;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.InterceptorProvider;

public abstract class AbstractFeature
extends WebServiceFeature
implements Feature {
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public void initialize(Server server, Bus bus) {
        this.initializeProvider(server.getEndpoint(), bus);
    }

    @Override
    public void initialize(Client client, Bus bus) {
        this.initializeProvider(client, bus);
    }

    @Override
    public void initialize(InterceptorProvider interceptorProvider, Bus bus) {
        this.initializeProvider(interceptorProvider, bus);
    }

    @Override
    public void initialize(Bus bus) {
        this.initializeProvider(bus, bus);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
    }

    public static <T> T getActive(List<? extends Feature> features, Class<T> type) {
        T active = null;
        if (features != null) {
            for (Feature feature : features) {
                if (!type.isInstance(feature)) continue;
                active = type.cast(feature);
                break;
            }
        }
        return active;
    }
}

