/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.util.Collection;
import org.hawkular.agent.monitor.extension.SubsystemAdd;
import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.extension.SubsystemRemove;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class MonitorServiceRestartParentAttributeHandler
extends RestartParentWriteAttributeHandler {
    private static final OperationContext.AttachmentKey<Integer> RECREATE_COUNTER = OperationContext.AttachmentKey.create(Integer.class);
    private static final OperationContext.AttachmentKey<Integer> REMOVE_COUNTER = OperationContext.AttachmentKey.create(Integer.class);

    public MonitorServiceRestartParentAttributeHandler(AttributeDefinition ... definitions) {
        super("subsystem", definitions);
    }

    public MonitorServiceRestartParentAttributeHandler(Collection<AttributeDefinition> definitions) {
        super("subsystem", definitions);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return SubsystemExtension.SERVICE_NAME;
    }

    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return true;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void removeServices(OperationContext context, ServiceName parentService, final ModelNode parentModel) throws OperationFailedException {
        this.incrementAttachedCounter(context, REMOVE_COUNTER);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Integer counter = MonitorServiceRestartParentAttributeHandler.this.decrementAttachedCounter(context, (OperationContext.AttachmentKey<Integer>)REMOVE_COUNTER);
                if (counter == 0) {
                    SubsystemRemove.INSTANCE.performRuntime(context, null, parentModel);
                } else if (counter < 0) {
                    throw new OperationFailedException("The removeServices step got added more times than needed - This shouldn't happen.");
                }
                WildflyCompatibilityUtils.operationContextStepCompleted(context);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void recreateParentService(OperationContext context, final PathAddress parentAddress, final ModelNode parentModel) throws OperationFailedException {
        this.incrementAttachedCounter(context, RECREATE_COUNTER);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Integer counter = MonitorServiceRestartParentAttributeHandler.this.decrementAttachedCounter(context, (OperationContext.AttachmentKey<Integer>)RECREATE_COUNTER);
                if (counter == 0) {
                    SubsystemAdd.INSTANCE.performRuntime(context, new ModelNode().set("address", parentAddress.toModelNode()), parentModel);
                } else if (counter < 0) {
                    throw new OperationFailedException("The recreateParentService step got added more times than needed - This shouldn't happen.");
                }
                WildflyCompatibilityUtils.operationContextStepCompleted(context);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<ModelNode> handbackHolder) throws OperationFailedException {
        MonitorService agent;
        if (!context.isBooting() && (agent = this.getMonitorService(context)).isImmutable()) {
            throw new OperationFailedException("The agent is configured to be immutable - no changes are allowed");
        }
        return super.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handbackHolder);
    }

    protected MonitorService getMonitorService(OperationContext opContext) {
        ServiceName name = SubsystemExtension.SERVICE_NAME;
        ServiceRegistry serviceRegistry = opContext.getServiceRegistry(true);
        MonitorService service = (MonitorService)serviceRegistry.getRequiredService(name).getValue();
        return service;
    }

    private Integer incrementAttachedCounter(OperationContext context, OperationContext.AttachmentKey<Integer> key) {
        Integer value = (Integer)context.getAttachment(key);
        if (value == null) {
            value = 0;
        }
        value = value + 1;
        context.attach(key, (Object)value);
        return value;
    }

    private Integer decrementAttachedCounter(OperationContext context, OperationContext.AttachmentKey<Integer> key) {
        Integer value = (Integer)context.getAttachment(key);
        if (value == null) {
            return null;
        }
        value = value - 1;
        context.attach(key, (Object)value);
        return value;
    }
}

