/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xnio.IoUtils;

public class DelegatingResourceManager
implements ResourceManager {
    private final List<ResourceManager> delegates;

    public DelegatingResourceManager(List<ResourceManager> delegates) {
        this.delegates = new ArrayList<ResourceManager>(delegates);
    }

    public Resource getResource(String path) throws IOException {
        for (ResourceManager d : this.delegates) {
            Resource res = d.getResource(path);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public boolean isResourceChangeListenerSupported() {
        return true;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
        for (ResourceManager del : this.delegates) {
            if (!del.isResourceChangeListenerSupported()) continue;
            del.registerResourceChangeListener(listener);
        }
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
        for (ResourceManager del : this.delegates) {
            if (!del.isResourceChangeListenerSupported()) continue;
            del.removeResourceChangeListener(listener);
        }
    }

    public void close() throws IOException {
        for (ResourceManager del : this.delegates) {
            IoUtils.safeClose((Closeable)del);
        }
    }
}

