/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.security;

import java.security.BasicPermission;
import org.jboss.as.controller.logging.ControllerLogger;

public class ControllerPermission
extends BasicPermission {
    public static final String CAN_ACCESS_IMMUTABLE_MANAGEMENT_RESOURCE_REGISTRATION_NAME = "canAccessImmutableManagementResourceRegistration";
    public static final String CAN_ACCESS_MODEL_CONTROLLER_NAME = "canAccessModelController";
    public static final String CREATE_CALLER_NAME = "createCaller";
    public static final String GET_CALLER_SUBJECT_NAME = "getCallerSubject";
    public static final String GET_CURRENT_ACCESS_AUDIT_CONTEXT_NAME = "getCurrentAccessAuditContext";
    private static final String WILDCARD_NAME = "*";
    public static final ControllerPermission CAN_ACCESS_IMMUTABLE_MANAGEMENT_RESOURCE_REGISTRATION = new ControllerPermission("canAccessImmutableManagementResourceRegistration");
    public static final ControllerPermission CAN_ACCESS_MODEL_CONTROLLER = new ControllerPermission("canAccessModelController");
    public static final ControllerPermission CREATE_CALLER = new ControllerPermission("createCaller");
    public static final ControllerPermission GET_CALLER_SUBJECT = new ControllerPermission("getCallerSubject");
    public static final ControllerPermission GET_CURRENT_ACCESS_AUDIT_CONTEXT = new ControllerPermission("getCurrentAccessAuditContext");

    private static String validatePermissionName(String name) throws IllegalArgumentException {
        switch (name) {
            case "canAccessImmutableManagementResourceRegistration": 
            case "canAccessModelController": 
            case "createCaller": 
            case "getCallerSubject": 
            case "getCurrentAccessAuditContext": 
            case "*": {
                return name;
            }
        }
        throw ControllerLogger.ACCESS_LOGGER.illegalPermissionName(name);
    }

    private static String validatePermissionActions(String actions) throws IllegalArgumentException {
        if (actions != null) {
            throw ControllerLogger.ACCESS_LOGGER.illegalPermissionActions(actions);
        }
        return actions;
    }

    public ControllerPermission(String name) {
        super(ControllerPermission.validatePermissionName(name));
    }

    public ControllerPermission(String name, String actions) {
        super(ControllerPermission.validatePermissionName(name), ControllerPermission.validatePermissionActions(actions));
    }
}

