/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import org.hawkular.inventory.api.Action;

public final class Interest<C, E> {
    private final Action<C, E> action;
    private final Class<E> entityType;

    public static <T> Builder<T> in(Class<T> entity) {
        return new Builder(entity);
    }

    public Interest(Action<C, E> action, Class<E> entityType) {
        this.action = action;
        this.entityType = entityType;
    }

    public Action<C, E> getAction() {
        return this.action;
    }

    public Class<E> getEntityType() {
        return this.entityType;
    }

    public boolean matches(Action<?, ?> action, Object object) {
        return this.action == action && object != null && this.entityType.isAssignableFrom(object.getClass());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interest interest = (Interest)o;
        if (this.action != interest.action) {
            return false;
        }
        return this.entityType.equals(interest.entityType);
    }

    public int hashCode() {
        int result = this.action.hashCode();
        result = 31 * result + this.entityType.hashCode();
        return result;
    }

    public String toString() {
        return "Interest[action=" + this.action + ", entityType=" + this.entityType + ']';
    }

    public static final class Builder<E> {
        private final Class<E> entityType;

        private Builder(Class<E> entityType) {
            this.entityType = entityType;
        }

        public <C> Interest<C, E> being(Action<C, E> action) {
            return new Interest<C, E>(action, this.entityType);
        }

        public <C> Interest<C, E> having(Action<C, E> action) {
            return this.being(action);
        }
    }
}

