/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.feeds;

import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.FeedAlreadyRegisteredException;
import org.hawkular.inventory.api.FeedIdStrategy;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.model.Feed;

public final class AcceptWithFallbackFeedIdStrategy
implements FeedIdStrategy {
    private final FeedIdStrategy fallback;

    public AcceptWithFallbackFeedIdStrategy() {
        this(null);
    }

    public AcceptWithFallbackFeedIdStrategy(FeedIdStrategy fallback) {
        this.fallback = fallback;
    }

    @Override
    public String generate(Inventory inventory, Feed proposedFeed) throws EntityAlreadyExistsException {
        try {
            if (!Feed.Blueprint.shouldAutogenerateId(proposedFeed)) {
                inventory.inspect(proposedFeed).entity();
            }
            if (this.fallback == null || !Feed.Blueprint.shouldAutogenerateId(proposedFeed)) {
                throw new FeedAlreadyRegisteredException(proposedFeed);
            }
            return this.fallback.generate(inventory, proposedFeed);
        }
        catch (EntityNotFoundException e) {
            return proposedFeed.getId();
        }
    }
}

