/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.List;
import org.jboss.dmr.ModelNode;

public interface HostConnectionInfo {
    public static final String ADDRESS = "address";
    public static final String CONNECTED = "connected";
    public static final String EVENTS = "events";
    public static final String TIMESTAMP = "timestamp";
    public static final String TYPE = "type";

    public String getHostName();

    public boolean isConnected();

    public List<Event> getEvents();

    public static enum EventType {
        REGISTERED("registered"),
        REGISTRATION_EXISTING("duplicate-registration"),
        REGISTRATION_REJECTED("registration-rejected"),
        REGISTRATION_FAILED("registration-failed"),
        UNCLEAN_UNREGISTRATION("unclean-unregistration"),
        UNREGISTERED("unregistered"),
        UNKNOWN("unknown");

        private final String name;

        private EventType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class BasicEventImpl
    implements Event {
        private final EventType type;
        private final String address;
        private final long timeStamp;

        public BasicEventImpl(EventType type, String address) {
            this.type = type;
            this.address = address;
            this.timeStamp = System.currentTimeMillis();
        }

        @Override
        public EventType getEventType() {
            return this.type;
        }

        @Override
        public String getPeerAddress() {
            return this.address;
        }

        @Override
        public long getTimestamp() {
            return this.timeStamp;
        }

        @Override
        public void toModelNode(ModelNode target) {
            target.get(HostConnectionInfo.TYPE);
            target.get(HostConnectionInfo.ADDRESS);
            if (this.type != null) {
                target.get(HostConnectionInfo.TYPE).set(this.type.getName());
            }
            if (this.address != null) {
                target.get(HostConnectionInfo.ADDRESS).set(this.address);
            }
            target.get(HostConnectionInfo.TIMESTAMP).set(this.timeStamp);
        }
    }

    public static class Events {
        private Events() {
        }

        public static Event create(EventType type, String address) {
            return new BasicEventImpl(type, address);
        }
    }

    public static interface Event {
        public EventType getEventType();

        public String getPeerAddress();

        public long getTimestamp();

        public void toModelNode(ModelNode var1);
    }
}

