/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    MOD_CLUSTER_CONFIG("mod-cluster-config"),
    LOAD_PROVIDER("load-provider"),
    PROXY_CONF("proxy-conf"),
    HTTPD_CONF("httpd-conf"),
    NODES_CONF("nodes-conf"),
    ADVERTISE_SOCKET("advertise-socket"),
    SSL("ssl"),
    DYNAMIC_LOAD_PROVIDER("dynamic-load-provider"),
    SIMPLE_LOAD_PROVIDER("simple-load-provider"),
    LOAD_METRIC("load-metric"),
    CUSTOM_LOAD_METRIC("custom-load-metric"),
    PROPERTY("property");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

