/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.client.common;

import org.hawkular.metrics.client.common.MetricType;

public class SingleMetric {
    private final String source;
    private final long timestamp;
    private final Double value;
    private final MetricType metricType;

    public SingleMetric(String source, long timestamp, Double value) {
        if (source == null) {
            throw new IllegalArgumentException("Source must not be null");
        }
        this.timestamp = timestamp;
        this.source = source;
        this.value = value;
        this.metricType = null;
    }

    public SingleMetric(String source, long timestamp, Double value, MetricType metricType) {
        if (source == null) {
            throw new IllegalArgumentException("Source must not be null");
        }
        this.source = source;
        this.timestamp = timestamp;
        this.value = value;
        this.metricType = metricType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getSource() {
        return this.source;
    }

    public Double getValue() {
        return this.value;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public String toString() {
        return "SingleMetric{type=" + (Object)((Object)this.metricType) + ", time=" + this.timestamp + ", src='" + this.source + '\'' + ", val=" + this.value + '}';
    }

    public String toJson() {
        return "{\"id\":\"" + this.source + "\",\"data\":[{\"timestamp\":" + String.valueOf(this.timestamp) + ",\"value\":" + String.valueOf(this.value) + "}]}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleMetric metric = (SingleMetric)o;
        if (this.timestamp != metric.timestamp) {
            return false;
        }
        if (this.metricType != metric.metricType) {
            return false;
        }
        return this.source.equals(metric.source);
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.metricType != null ? this.metricType.hashCode() : 0);
        return result;
    }
}

