/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.time.impl;

import java.time.Duration;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.time.impl.NumericTimeBridge;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DurationBridge
implements TwoWayFieldBridge,
NumericTimeBridge {
    private static final Log log = LoggerFactory.make();
    public static final DurationBridge INSTANCE = new DurationBridge();

    private DurationBridge() {
    }

    @Override
    public String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(this.toNanos((Duration)object));
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            Long nanos = this.toNanos((Duration)value);
            luceneOptions.addNumericFieldToDocument(name, nanos, document);
        }
    }

    private Long toNanos(Duration value) {
        try {
            Long nanos = value.toNanos();
            return nanos;
        }
        catch (ArithmeticException ae) {
            throw log.valueTooLargeForConversionException(Duration.class, value, ae);
        }
    }

    @Override
    public Object get(String name, Document document) {
        String nanosFromIndex = document.get(name);
        Long nanos = Long.valueOf(nanosFromIndex);
        return Duration.ofNanos(nanos);
    }

    @Override
    public NumericFieldSettingsDescriptor.NumericEncodingType getEncodingType() {
        return NumericFieldSettingsDescriptor.NumericEncodingType.LONG;
    }
}

