/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.flow.FlowCDIEventFireHelper;
import com.sun.faces.flow.FlowHandlerImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.FlowScoped;
import javax.faces.lifecycle.ClientWindow;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowCDIContext
implements Context,
Serializable {
    private static final long serialVersionUID = -7144653402477623609L;
    private static final String FLOW_SCOPE_MAP_KEY = "com.sun.faces.FLOW_SCOPE_MAP";
    private static final Logger LOGGER = FacesLogger.FLOW.getLogger();
    private transient Map<Contextual<?>, FlowBeanInfo> flowIds;
    private static final String PER_SESSION_BEAN_MAP_LIST = FlowCDIContext.class.getPackage().getName() + ".PER_SESSION_BEAN_MAP_LIST";
    private static final String PER_SESSION_CREATIONAL_LIST = FlowCDIContext.class.getPackage().getName() + ".PER_SESSION_CREATIONAL_LIST";

    FlowCDIContext(Map<Contextual<?>, FlowBeanInfo> flowIds) {
        this.flowIds = new ConcurrentHashMap(flowIds);
    }

    private static void ensureBeanMapCleanupOnSessionDestroyed(Map<String, Object> sessionMap, String flowBeansForClientWindow) {
        ArrayList<String> beanMapList = (ArrayList<String>)sessionMap.get(PER_SESSION_BEAN_MAP_LIST);
        if (null == beanMapList) {
            beanMapList = new ArrayList<String>();
            sessionMap.put(PER_SESSION_BEAN_MAP_LIST, beanMapList);
        }
        beanMapList.add(flowBeansForClientWindow);
    }

    private static void ensureCreationalCleanupOnSessionDestroyed(Map<String, Object> sessionMap, String creationalForClientWindow) {
        ArrayList<String> beanMapList = (ArrayList<String>)sessionMap.get(PER_SESSION_CREATIONAL_LIST);
        if (null == beanMapList) {
            beanMapList = new ArrayList<String>();
            sessionMap.put(PER_SESSION_CREATIONAL_LIST, beanMapList);
        }
        beanMapList.add(creationalForClientWindow);
    }

    private final void assertNotReleased() {
        if (!this.isActive()) {
            throw new IllegalStateException();
        }
    }

    private Flow getCurrentFlow() {
        Flow result = null;
        FacesContext context = FacesContext.getCurrentInstance();
        result = FlowCDIContext.getCurrentFlow(context);
        return result;
    }

    private static Flow getCurrentFlow(FacesContext context) {
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow result = flowHandler.getCurrentFlow(context);
        return result;
    }

    public static void sessionDestroyed(HttpSessionEvent hse) {
        List creationalList;
        HttpSession session = hse.getSession();
        List beanMapList = (List)session.getAttribute(PER_SESSION_BEAN_MAP_LIST);
        if (null != beanMapList) {
            for (String cur : beanMapList) {
                Map beanMap = (Map)session.getAttribute(cur);
                beanMap.clear();
                session.removeAttribute(cur);
            }
            session.removeAttribute(PER_SESSION_BEAN_MAP_LIST);
            beanMapList.clear();
        }
        if (null != (creationalList = (List)session.getAttribute(PER_SESSION_CREATIONAL_LIST))) {
            for (String cur : creationalList) {
                Map beanMap = (Map)session.getAttribute(cur);
                beanMap.clear();
                session.removeAttribute(cur);
            }
            session.removeAttribute(PER_SESSION_CREATIONAL_LIST);
            creationalList.clear();
        }
    }

    static Map<Object, Object> getCurrentFlowScopeAndUpdateSession() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FlowScopeMapHelper mapHelper = new FlowScopeMapHelper(facesContext);
        return FlowCDIContext.getCurrentFlowScopeAndUpdateSession(mapHelper);
    }

    private static Map<Object, Object> getCurrentFlowScopeAndUpdateSession(FlowScopeMapHelper mapHelper) {
        Map flowScopedBeanMap = mapHelper.getFlowScopedBeanMapForCurrentFlow();
        ConcurrentHashMap result = null;
        if (mapHelper.isFlowExists() && null == (result = (ConcurrentHashMap)flowScopedBeanMap.get(FLOW_SCOPE_MAP_KEY))) {
            result = new ConcurrentHashMap();
            flowScopedBeanMap.put(FLOW_SCOPE_MAP_KEY, result);
        }
        mapHelper.updateSession();
        return result;
    }

    static void flowExited(Flow currentFlow, int depth) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FlowScopeMapHelper mapHelper = new FlowScopeMapHelper(facesContext, currentFlow, depth);
        Map flowScopedBeanMap = mapHelper.getFlowScopedBeanMapForCurrentFlow();
        Map creationalMap = mapHelper.getFlowScopedCreationalMapForCurrentFlow();
        assert (!flowScopedBeanMap.isEmpty());
        assert (!creationalMap.isEmpty());
        ArrayList<String> flowScopedBeansToRemove = new ArrayList<String>();
        BeanManager beanManager = Util.getCdiBeanManager(facesContext);
        for (Map.Entry entry : flowScopedBeanMap.entrySet()) {
            String passivationCapableId = (String)entry.getKey();
            if (FLOW_SCOPE_MAP_KEY.equals(passivationCapableId)) continue;
            Bean owner = beanManager.getPassivationCapableBean(passivationCapableId);
            Object bean = entry.getValue();
            CreationalContext creational = (CreationalContext)creationalMap.get(passivationCapableId);
            owner.destroy(bean, creational);
            flowScopedBeansToRemove.add(passivationCapableId);
        }
        for (String cur : flowScopedBeansToRemove) {
            flowScopedBeanMap.remove(cur);
            creationalMap.remove(cur);
        }
        mapHelper.updateSession();
        if (Util.isCdiOneOneOrGreater()) {
            Set availableBeans;
            Class<?> flowCDIEventFireHelperImplClass;
            block8: {
                flowCDIEventFireHelperImplClass = null;
                try {
                    flowCDIEventFireHelperImplClass = Class.forName("com.sun.faces.flow.FlowCDIEventFireHelperImpl");
                }
                catch (ClassNotFoundException ex) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                    LOGGER.log(Level.SEVERE, "CDI 1.1 events not enabled", ex);
                }
            }
            if (null != flowCDIEventFireHelperImplClass && null != (availableBeans = beanManager.getBeans(flowCDIEventFireHelperImplClass, new Annotation[0])) && !availableBeans.isEmpty()) {
                Bean bean = beanManager.resolve(availableBeans);
                CreationalContext creationalContext = beanManager.createCreationalContext(null);
                FlowCDIEventFireHelper eventHelper = (FlowCDIEventFireHelper)beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
                eventHelper.fireDestroyedEvent(currentFlow);
            }
        }
    }

    static void flowEntered() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FlowScopeMapHelper mapHelper = new FlowScopeMapHelper(facesContext);
        mapHelper.createMaps();
        FlowCDIContext.getCurrentFlowScopeAndUpdateSession(mapHelper);
        if (Util.isCdiOneOneOrGreater()) {
            BeanManager beanManager;
            Set availableBeans;
            Class<?> flowCDIEventFireHelperImplClass;
            block4: {
                flowCDIEventFireHelperImplClass = null;
                try {
                    flowCDIEventFireHelperImplClass = Class.forName("com.sun.faces.flow.FlowCDIEventFireHelperImpl");
                }
                catch (ClassNotFoundException ex) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                    LOGGER.log(Level.SEVERE, "CDI 1.1 events not enabled", ex);
                }
            }
            if (null != flowCDIEventFireHelperImplClass && null != (availableBeans = (beanManager = Util.getCdiBeanManager(facesContext)).getBeans(flowCDIEventFireHelperImplClass, new Annotation[0])) && !availableBeans.isEmpty()) {
                Bean bean = beanManager.resolve(availableBeans);
                CreationalContext creationalContext = beanManager.createCreationalContext(null);
                FlowCDIEventFireHelper eventHelper = (FlowCDIEventFireHelper)beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
                eventHelper.fireInitializedEvent(FlowCDIContext.getCurrentFlow(facesContext));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creational) {
        this.assertNotReleased();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FlowScopeMapHelper mapHelper = new FlowScopeMapHelper(facesContext);
        Object result = this.get(mapHelper, contextual);
        if (null == result) {
            Map flowScopedBeanMap = mapHelper.getFlowScopedBeanMapForCurrentFlow();
            Map creationalMap = mapHelper.getFlowScopedCreationalMapForCurrentFlow();
            String passivationCapableId = ((PassivationCapable)contextual).getId();
            Map map = flowScopedBeanMap;
            synchronized (map) {
                result = flowScopedBeanMap.get(passivationCapableId);
                if (null == result) {
                    FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                    if (null == flowHandler) {
                        return null;
                    }
                    FlowBeanInfo fbi = this.flowIds.get(contextual);
                    if (!flowHandler.isActive(facesContext, fbi.definingDocumentId, fbi.id)) {
                        throw new ContextNotActiveException("Request to activate bean in flow '" + fbi + "', but that flow is not active.");
                    }
                    result = contextual.create(creational);
                    if (null != result) {
                        flowScopedBeanMap.put(passivationCapableId, result);
                        creationalMap.put(passivationCapableId, creational);
                        mapHelper.updateSession();
                    }
                }
            }
        }
        mapHelper = null;
        return result;
    }

    public <T> T get(Contextual<T> contextual) {
        this.assertNotReleased();
        if (!(contextual instanceof PassivationCapable)) {
            throw new IllegalArgumentException("FlowScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
        }
        FlowScopeMapHelper mapHelper = new FlowScopeMapHelper(FacesContext.getCurrentInstance());
        T result = this.get(mapHelper, contextual);
        mapHelper = null;
        return result;
    }

    private <T> T get(FlowScopeMapHelper mapHelper, Contextual<T> contextual) {
        this.assertNotReleased();
        if (!(contextual instanceof PassivationCapable)) {
            throw new IllegalArgumentException("FlowScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
        }
        String passivationCapableId = ((PassivationCapable)contextual).getId();
        return (T)mapHelper.getFlowScopedBeanMapForCurrentFlow().get(passivationCapableId);
    }

    public Class<? extends Annotation> getScope() {
        return FlowScoped.class;
    }

    public boolean isActive() {
        return null != this.getCurrentFlow();
    }

    void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FlowScopeMapHelper {
        private transient String flowBeansForClientWindowKey;
        private transient String creationalForClientWindowKey;
        private final transient Map<String, Object> sessionMap;

        private FlowScopeMapHelper(FacesContext facesContext) {
            ExternalContext extContext = facesContext.getExternalContext();
            this.sessionMap = extContext.getSessionMap();
            Flow currentFlow = FlowCDIContext.getCurrentFlow(facesContext);
            int currentFlowDepth = FlowHandlerImpl.getFlowStack(facesContext).getCurrentFlowDepth();
            this.generateKeyForCDIBeansBelongToAFlow(facesContext, currentFlow, currentFlowDepth);
        }

        private FlowScopeMapHelper(FacesContext facesContext, Flow flow, int flowDepth) {
            ExternalContext extContext = facesContext.getExternalContext();
            this.sessionMap = extContext.getSessionMap();
            this.generateKeyForCDIBeansBelongToAFlow(facesContext, flow, flowDepth);
        }

        private void generateKeyForCDIBeansBelongToAFlow(FacesContext facesContext, Flow flow, int flowDepth) {
            if (null != flow) {
                ClientWindow curWindow = facesContext.getExternalContext().getClientWindow();
                if (null == curWindow) {
                    throw new IllegalStateException("Unable to obtain current ClientWindow.  Is the ClientWindow feature enabled?");
                }
                String clientWindow = flow.getClientWindowFlowId(curWindow);
                this.flowBeansForClientWindowKey = clientWindow + ":" + flowDepth + "_beans";
                this.creationalForClientWindowKey = clientWindow + ":" + flowDepth + "_creational";
            } else {
                this.creationalForClientWindowKey = null;
                this.flowBeansForClientWindowKey = null;
            }
        }

        private void createMaps() {
            this.getFlowScopedBeanMapForCurrentFlow();
            this.getFlowScopedCreationalMapForCurrentFlow();
        }

        private boolean isFlowExists() {
            return null != this.flowBeansForClientWindowKey && null != this.creationalForClientWindowKey;
        }

        public String getCreationalForClientWindowKey() {
            return this.creationalForClientWindowKey;
        }

        public String getFlowBeansForClientWindowKey() {
            return this.flowBeansForClientWindowKey;
        }

        private Map<String, Object> getFlowScopedBeanMapForCurrentFlow() {
            if (null == this.flowBeansForClientWindowKey && null == this.creationalForClientWindowKey) {
                return Collections.emptyMap();
            }
            ConcurrentHashMap result = (ConcurrentHashMap)this.sessionMap.get(this.flowBeansForClientWindowKey);
            if (null == result) {
                result = new ConcurrentHashMap();
                this.sessionMap.put(this.flowBeansForClientWindowKey, result);
                FlowCDIContext.ensureBeanMapCleanupOnSessionDestroyed(this.sessionMap, this.flowBeansForClientWindowKey);
            }
            return result;
        }

        private Map<String, CreationalContext<?>> getFlowScopedCreationalMapForCurrentFlow() {
            if (null == this.flowBeansForClientWindowKey && null == this.creationalForClientWindowKey) {
                return Collections.emptyMap();
            }
            ConcurrentHashMap result = (ConcurrentHashMap)this.sessionMap.get(this.creationalForClientWindowKey);
            if (null == result) {
                result = new ConcurrentHashMap();
                this.sessionMap.put(this.creationalForClientWindowKey, result);
                FlowCDIContext.ensureCreationalCleanupOnSessionDestroyed(this.sessionMap, this.creationalForClientWindowKey);
            }
            return result;
        }

        private void updateSession() {
            if (null == this.flowBeansForClientWindowKey && null == this.creationalForClientWindowKey) {
                return;
            }
            this.sessionMap.put(this.flowBeansForClientWindowKey, this.getFlowScopedBeanMapForCurrentFlow());
            this.sessionMap.put(this.creationalForClientWindowKey, this.getFlowScopedCreationalMapForCurrentFlow());
            Object obj = this.sessionMap.get(PER_SESSION_BEAN_MAP_LIST);
            if (null != obj) {
                this.sessionMap.put(PER_SESSION_BEAN_MAP_LIST, obj);
            }
            if (null != (obj = this.sessionMap.get(PER_SESSION_CREATIONAL_LIST))) {
                this.sessionMap.put(PER_SESSION_CREATIONAL_LIST, obj);
            }
        }
    }

    static class FlowBeanInfo {
        String definingDocumentId;
        String id;

        FlowBeanInfo() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlowBeanInfo other = (FlowBeanInfo)obj;
            if (this.definingDocumentId == null ? other.definingDocumentId != null : !this.definingDocumentId.equals(other.definingDocumentId)) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.definingDocumentId != null ? this.definingDocumentId.hashCode() : 0);
            hash = 79 * hash + (this.id != null ? this.id.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return "FlowBeanInfo{definingDocumentId=" + this.definingDocumentId + ", id=" + this.id + '}';
        }
    }
}

