/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol;

import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.DiscoveryEvent;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MeasurementType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.inventory.ResourceTypeManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.Discovery;
import org.hawkular.agent.monitor.protocol.Driver;
import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.hawkular.agent.monitor.protocol.Session;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.storage.NumericMetricDataPoint;
import org.hawkular.agent.monitor.storage.StringMetricDataPoint;
import org.hawkular.agent.monitor.util.Consumer;
import org.hawkular.agent.monitor.util.ThreadFactoryGenerator;
import org.jboss.as.controller.client.helpers.MeasurementUnit;

public abstract class EndpointService<L, S extends Session<L>>
implements SamplingService<L> {
    private static final MsgLogger LOG = AgentLoggers.getLogger(EndpointService.class);
    private final MonitoredEndpoint<MonitorServiceConfiguration.EndpointConfiguration> endpoint;
    private final String feedId;
    private final InventoryListenerSupport inventoryListenerSupport = new InventoryListenerSupport();
    private final ResourceManager<L> resourceManager;
    private final ResourceTypeManager<L> resourceTypeManager;
    private final LocationResolver<L> locationResolver;
    private final ProtocolDiagnostics diagnostics;
    private final ExecutorService fullDiscoveryScanThreadPool;
    protected volatile ServiceStatus status = ServiceStatus.INITIAL;

    public EndpointService(String feedId, MonitoredEndpoint<MonitorServiceConfiguration.EndpointConfiguration> endpoint, ResourceTypeManager<L> resourceTypeManager, LocationResolver<L> locationResolver, ProtocolDiagnostics diagnostics) {
        this.feedId = feedId;
        this.endpoint = endpoint;
        this.resourceManager = new ResourceManager();
        this.resourceTypeManager = resourceTypeManager;
        this.locationResolver = locationResolver;
        this.diagnostics = diagnostics;
        ThreadFactory threadFactory = ThreadFactoryGenerator.generateFactory(true, "Hawkular WildFly Agent Full Discovery Scan-" + endpoint.getName());
        this.fullDiscoveryScanThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1), threadFactory);
    }

    public String getFeedId() {
        return this.feedId;
    }

    @Override
    public MonitoredEndpoint<MonitorServiceConfiguration.EndpointConfiguration> getMonitoredEndpoint() {
        return this.endpoint;
    }

    public ResourceManager<L> getResourceManager() {
        return this.resourceManager;
    }

    public ResourceTypeManager<L> getResourceTypeManager() {
        return this.resourceTypeManager;
    }

    public LocationResolver<L> getLocationResolver() {
        return this.locationResolver;
    }

    public ProtocolDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public void addInventoryListener(InventoryListener listener) {
        this.inventoryListenerSupport.inventoryListenerRWLock.writeLock().lock();
        try {
            this.status.assertInitialOrStopped(this.getClass(), "addInventoryListener()");
            this.inventoryListenerSupport.inventoryListeners.add(listener);
            LOG.debugf("Added inventory listener [%s] for endpoint [%s]", listener, this.getMonitoredEndpoint());
        }
        finally {
            this.inventoryListenerSupport.inventoryListenerRWLock.writeLock().unlock();
        }
    }

    public void removeInventoryListener(InventoryListener listener) {
        this.inventoryListenerSupport.inventoryListenerRWLock.writeLock().lock();
        try {
            this.status.assertInitialOrStopped(this.getClass(), "removeInventoryListener()");
            this.inventoryListenerSupport.inventoryListeners.remove(listener);
            LOG.debugf("Removed inventory listener [%s] for endpoint [%s]", listener, this.getMonitoredEndpoint());
        }
        finally {
            this.inventoryListenerSupport.inventoryListenerRWLock.writeLock().unlock();
        }
    }

    public abstract S openSession();

    public void discoverAll() {
        this.status.assertRunning(this.getClass(), "discoverAll()");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DiscoveryResults discoveryResults = new DiscoveryResults();
                LOG.infoDiscoveryRequested(EndpointService.this.getMonitoredEndpoint());
                long duration = -1L;
                try (Object session = EndpointService.this.openSession();){
                    Set rootTypes = EndpointService.this.getResourceTypeManager().getRootResourceTypes();
                    Timer.Context timer = EndpointService.this.getDiagnostics().getFullDiscoveryScanTimer().time();
                    for (ResourceType rootType : rootTypes) {
                        EndpointService.this.discoverChildren(null, rootType, session, discoveryResults);
                    }
                    long nanos = timer.stop();
                    duration = TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS);
                }
                catch (Exception e) {
                    LOG.errorCouldNotAccess(EndpointService.this, e);
                    discoveryResults.error(e);
                }
                EndpointService.this.getResourceManager().logTreeGraph("Discovered all resources for: " + EndpointService.this.getMonitoredEndpoint(), duration);
                discoveryResults.discoveryFinished();
            }
        };
        try {
            this.fullDiscoveryScanThreadPool.execute(runnable);
        }
        catch (RejectedExecutionException ree) {
            LOG.debugf("Redundant full discovery scan will be ignored for endpoint [%s]", this.getMonitoredEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverChildren(L parentLocation, ResourceType<L> childType, S session, final DiscoveryResults discoveryResults) {
        this.status.assertRunning(this.getClass(), "discoverChildren()");
        LOG.debugf("Being asked to discover children of type [%s] under parent [%s] for endpoint [%s]", childType, parentLocation, this.getMonitoredEndpoint());
        Closeable sessionToUse = null;
        try {
            sessionToUse = (Closeable)(session == null ? this.openSession() : session);
            List<Resource<L>> parents = parentLocation != null ? this.getResourceManager().findResources(parentLocation, ((Session)sessionToUse).getLocationResolver()) : Arrays.asList(new Resource[]{null});
            Discovery<L> discovery = new Discovery<L>();
            for (Resource<L> parent : parents) {
                discovery.discoverChildren(parent, childType, (Session<L>)sessionToUse, this, new Consumer<Resource<L>>(){

                    @Override
                    public void accept(Resource<L> resource) {
                        ResourceManager.AddResult addResult = EndpointService.this.getResourceManager().addResource(resource);
                        switch (addResult.getEffect()) {
                            case ADDED: {
                                discoveryResults.added(addResult.getResource());
                                break;
                            }
                            case MODIFIED: {
                                discoveryResults.modified(addResult.getResource());
                                break;
                            }
                            case UNCHANGED: {
                                discoveryResults.unchanged(addResult.getResource());
                                break;
                            }
                            default: {
                                throw new RuntimeException("Bad effect; report this bug: " + (Object)((Object)addResult.getEffect()));
                            }
                        }
                    }

                    @Override
                    public void report(Throwable t) {
                        discoveryResults.error(t);
                        LOG.errorCouldNotAccess(EndpointService.this, t);
                    }
                });
            }
        }
        catch (Exception e) {
            discoveryResults.error(e);
            LOG.errorCouldNotAccess(this, e);
        }
        finally {
            if (session == null && sessionToUse != null) {
                try {
                    sessionToUse.close();
                }
                catch (IOException ioe) {
                    LOG.warnf("Could not close session created for children discovery", ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void measureAvails(Collection<MeasurementInstance<L, AvailType<L>>> instances, Consumer<AvailDataPoint> consumer) {
        this.status.assertRunning(this.getClass(), "measureAvails()");
        LOG.debugf("Checking [%d] avails for endpoint [%s]", instances.size(), this.getMonitoredEndpoint());
        Session session = null;
        Driver driver = null;
        try {
            session = (Session)this.openSession();
            driver = session.getDriver();
        }
        catch (Exception e) {
            LOG.errorCouldNotAccess(this, e);
        }
        try {
            for (MeasurementInstance<L, AvailType<L>> instance : instances) {
                Avail avail;
                block22: {
                    avail = null;
                    if (driver != null) {
                        AttributeLocation location = instance.getAttributeLocation();
                        try {
                            Object o = driver.fetchAttribute(location);
                            Pattern pattern = ((AvailType)instance.getType()).getUpPattern();
                            if (o instanceof List) {
                                List list = (List)o;
                                for (Object item : list) {
                                    Avail a = this.toAvail(pattern, item);
                                    if (avail == null) {
                                        avail = a;
                                        continue;
                                    }
                                    avail = a == Avail.DOWN ? Avail.DOWN : avail;
                                }
                                break block22;
                            }
                            avail = this.toAvail(((AvailType)instance.getType()).getUpPattern(), o);
                        }
                        catch (Exception e) {
                            LOG.errorAvailCheckFailed(e);
                            avail = Avail.DOWN;
                        }
                    } else {
                        avail = Avail.DOWN;
                    }
                }
                long ts = System.currentTimeMillis();
                String key = instance.getAssociatedMetricId();
                AvailDataPoint dataPoint = new AvailDataPoint(key, ts, avail, this.getMonitoredEndpoint().getEndpointConfiguration().getTenantId());
                consumer.accept(dataPoint);
            }
        }
        catch (Exception e) {
            LOG.errorAvailCheckFailed(e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (IOException e) {
                    LOG.tracef(e, "Failed to close session for endpoint [%s]", session.getEndpoint());
                }
            }
        }
    }

    @Override
    public void measureMetrics(Collection<MeasurementInstance<L, MetricType<L>>> instances, Consumer<MetricDataPoint> consumer) {
        this.status.assertRunning(this.getClass(), "measureMetrics()");
        LOG.debugf("Collecting [%d] metrics for endpoint [%s]", instances.size(), this.getMonitoredEndpoint());
        try (S session = this.openSession();){
            Driver driver = ((Session)session).getDriver();
            for (MeasurementInstance<L, MetricType<L>> instance : instances) {
                Object metricValue;
                AttributeLocation location = instance.getAttributeLocation();
                Object o = driver.fetchAttribute(location);
                if (((MetricType)instance.getType()).getMetricType() == org.hawkular.metrics.client.common.MetricType.STRING) {
                    StringBuilder svalue = new StringBuilder();
                    if (o instanceof List) {
                        List list = (List)o;
                        for (Iterator item : list) {
                            if (svalue.length() > 0) {
                                svalue.append(",");
                            }
                            svalue.append(String.valueOf(item));
                        }
                    } else {
                        svalue.append(String.valueOf(o));
                    }
                    metricValue = svalue.toString();
                } else {
                    double dvalue = 0.0;
                    if (o instanceof List) {
                        Iterator item;
                        List list = (List)o;
                        item = list.iterator();
                        while (item.hasNext()) {
                            Object item2 = item.next();
                            double num = this.toDouble(item2);
                            dvalue += num;
                        }
                    } else {
                        dvalue = this.toDouble(o);
                    }
                    metricValue = dvalue;
                }
                long ts = System.currentTimeMillis();
                String key = instance.getAssociatedMetricId();
                String tenantId = this.getMonitoredEndpoint().getEndpointConfiguration().getTenantId();
                MetricDataPoint dataPoint = ((MetricType)instance.getType()).getMetricType() == org.hawkular.metrics.client.common.MetricType.STRING ? new StringMetricDataPoint(key, ts, (String)metricValue, tenantId) : new NumericMetricDataPoint(key, ts, (Double)metricValue, ((MetricType)instance.getType()).getMetricType(), tenantId);
                consumer.accept(dataPoint);
            }
        }
        catch (Exception e) {
            LOG.errorCouldNotAccess(this, e);
        }
    }

    @Override
    public String generateAssociatedMetricId(MeasurementInstance<L, ? extends MeasurementType<L>> instance) {
        MonitorServiceConfiguration.EndpointConfiguration config = this.getMonitoredEndpoint().getEndpointConfiguration();
        String metricIdTemplate = ((MeasurementType)instance.getType()).getMetricIdTemplate();
        if (metricIdTemplate == null || metricIdTemplate.isEmpty()) {
            metricIdTemplate = config.getMetricIdTemplate();
        }
        String generatedKey = metricIdTemplate == null || metricIdTemplate.isEmpty() ? instance.getID().getIDString() : this.replaceTokens(instance, config, metricIdTemplate);
        return generatedKey;
    }

    @Override
    public Map<String, String> generateAssociatedMetricTags(MeasurementInstance<L, ? extends MeasurementType<L>> instance) {
        Map<String, String> generatedTags;
        MonitorServiceConfiguration.EndpointConfiguration config = this.getMonitoredEndpoint().getEndpointConfiguration();
        HashMap<String, String> tokenizedTags = new HashMap<String, String>();
        if (config.getMetricTags() != null) {
            tokenizedTags.putAll(config.getMetricTags());
        }
        if (((MeasurementType)instance.getType()).getMetricTags() != null) {
            tokenizedTags.putAll(((MeasurementType)instance.getType()).getMetricTags());
        }
        if (tokenizedTags.isEmpty()) {
            generatedTags = Collections.emptyMap();
        } else {
            generatedTags = new HashMap<String, String>(tokenizedTags.size());
            for (Map.Entry tokenizedTag : tokenizedTags.entrySet()) {
                String name = this.replaceTokens(instance, config, (String)tokenizedTag.getKey());
                String value = this.replaceTokens(instance, config, (String)tokenizedTag.getValue());
                generatedTags.put(name, value);
            }
        }
        return generatedTags;
    }

    private String replaceTokens(MeasurementInstance<L, ?> instance, MonitorServiceConfiguration.EndpointConfiguration config, String string) {
        MeasurementUnit units = null;
        if (instance.getType() instanceof MetricType) {
            units = ((MetricType)instance.getType()).getMetricUnits();
        }
        return string.replaceAll("%FeedId", this.getFeedId()).replaceAll("%ManagedServerName", config.getName()).replaceAll("%ResourceName", instance.getResource().getName().getNameString()).replaceAll("%ResourceID", instance.getResource().getID().getIDString()).replaceAll("%MetricTypeName", ((MeasurementType)instance.getType()).getName().getNameString()).replaceAll("%MetricTypeID", ((MeasurementType)instance.getType()).getID().getIDString()).replaceAll("%MetricTypeUnits", units == null ? "" : units.toString()).replaceAll("%MetricInstanceID", instance.getID().getIDString());
    }

    public void removeResources(L location) {
        this.status.assertRunning(this.getClass(), "removeResources()");
        try (S session = this.openSession();){
            List<Resource<L>> removed = this.getResourceManager().removeResources(location, ((Session)session).getLocationResolver());
            this.inventoryListenerSupport.fireResourcesRemoved(removed);
        }
        catch (Exception e) {
            LOG.errorCouldNotAccess(this, e);
        }
    }

    public final void start() {
        this.status.assertInitialOrStopped(this.getClass(), "start()");
        this.status = ServiceStatus.STARTING;
        this.status = ServiceStatus.RUNNING;
        LOG.debugf("Started [%s]", this.toString());
    }

    public void stop() {
        this.status.assertRunning(this.getClass(), "stop()");
        this.status = ServiceStatus.STOPPING;
        this.status = ServiceStatus.STOPPED;
        LOG.debugf("Stopped [%s]", this.toString());
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getMonitoredEndpoint());
    }

    public int hashCode() {
        int result = 31 + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EndpointService)) {
            return false;
        }
        EndpointService other = (EndpointService)obj;
        return !(this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint));
    }

    private double toDouble(Object valueObject) {
        double value = valueObject == null ? Double.NaN : (valueObject instanceof Number ? ((Number)valueObject).doubleValue() : Double.valueOf(valueObject.toString()).doubleValue());
        return value;
    }

    private Avail toAvail(Pattern pattern, Object value) {
        if (pattern == null) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? Avail.UP : Avail.DOWN;
            }
            if (value instanceof String) {
                return AvailType.getDefaultUpPattern().matcher((String)value).matches() ? Avail.UP : Avail.DOWN;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() == 0 ? Avail.DOWN : Avail.UP;
            }
            throw new RuntimeException("Cannot handle an availability value of type [" + value.getClass().getName() + "]");
        }
        return pattern.matcher(String.valueOf(value)).matches() ? Avail.UP : Avail.DOWN;
    }

    private class DiscoveryResults {
        private final List<Resource<L>> newOrModifiedResources = new ArrayList();
        private final List<ID> discoveredResourceIds = new ArrayList<ID>();
        private final List<Throwable> errors = new ArrayList<Throwable>();

        public void error(Throwable t) {
            this.errors.add(t);
        }

        public void added(Resource<L> resource) {
            this.discoveredResourceIds.add(resource.getID());
            this.newOrModifiedResources.add(resource);
        }

        public void modified(Resource<L> resource) {
            this.discoveredResourceIds.add(resource.getID());
            this.newOrModifiedResources.add(resource);
        }

        public void unchanged(Resource<L> resource) {
            this.discoveredResourceIds.add(resource.getID());
        }

        public void discoveryFinished() {
            List removedResources = EndpointService.this.getResourceManager().getAllResources(this.discoveredResourceIds);
            removedResources.forEach(r -> EndpointService.this.getResourceManager().removeResource(r));
            EndpointService.this.inventoryListenerSupport.fireResourcesAdded(this.newOrModifiedResources);
            EndpointService.this.inventoryListenerSupport.fireResourcesRemoved(removedResources);
            if (this.errors.isEmpty()) {
                EndpointService.this.inventoryListenerSupport.fireDiscoveryComplete();
            } else {
                LOG.debugf("[%d] discovery errors occurred - not firing event: %s", this.errors.size(), this.errors);
            }
        }
    }

    private class InventoryListenerSupport {
        private final List<InventoryListener> inventoryListeners = new ArrayList<InventoryListener>();
        private final ReadWriteLock inventoryListenerRWLock = new ReentrantReadWriteLock();

        private InventoryListenerSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireResourcesAdded(List<Resource<L>> resources) {
            if (!resources.isEmpty()) {
                this.inventoryListenerRWLock.readLock().lock();
                try {
                    LOG.debugf("Firing inventory event for [%d] added/modified resources", resources.size());
                    InventoryEvent event = new InventoryEvent(EndpointService.this, resources);
                    for (InventoryListener inventoryListener : this.inventoryListeners) {
                        inventoryListener.resourcesAdded(event);
                    }
                }
                finally {
                    this.inventoryListenerRWLock.readLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireResourcesRemoved(List<Resource<L>> resources) {
            if (!resources.isEmpty()) {
                this.inventoryListenerRWLock.readLock().lock();
                try {
                    LOG.debugf("Firing inventory event for [%d] removed resources", resources.size());
                    InventoryEvent event = new InventoryEvent(EndpointService.this, resources);
                    for (InventoryListener inventoryListener : this.inventoryListeners) {
                        inventoryListener.resourcesRemoved(event);
                    }
                }
                finally {
                    this.inventoryListenerRWLock.readLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDiscoveryComplete() {
            this.inventoryListenerRWLock.readLock().lock();
            try {
                LOG.debugf("Firing inventory event for discovery complete", new Object[0]);
                DiscoveryEvent event = new DiscoveryEvent(EndpointService.this, EndpointService.this.getResourceManager(), EndpointService.this.getResourceTypeManager());
                for (InventoryListener inventoryListener : this.inventoryListeners) {
                    inventoryListener.discoveryCompleted(event);
                }
            }
            finally {
                this.inventoryListenerRWLock.readLock().unlock();
            }
        }
    }
}

