/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.lang.annotation.Annotation;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.providers.jaxb.IgnoreMediaTypes;
import org.jboss.resteasy.util.FindAnnotation;

public class IgnoredMediaTypes {
    private static String getVendorString(String subtype) {
        int idx = subtype.indexOf(43);
        if (idx < 0) {
            return subtype;
        }
        return subtype.substring(0, idx);
    }

    private static String getSubtype(String subtype) {
        int idx = subtype.indexOf(43);
        if (idx < 0) {
            return subtype;
        }
        return subtype.substring(idx + 1);
    }

    public static boolean ignored(Class<?> type, Annotation[] annotations, MediaType mediaType) {
        IgnoreMediaTypes ignore = (IgnoreMediaTypes)FindAnnotation.findAnnotation(type, (Annotation[])annotations, IgnoreMediaTypes.class);
        if (ignore == null) {
            return false;
        }
        for (String mime : ignore.value()) {
            if (!IgnoredMediaTypes.compare(mediaType, mime)) continue;
            return true;
        }
        return false;
    }

    private static boolean compare(MediaType mediaType, String mime) {
        MediaType mt = MediaType.valueOf((String)mime);
        if (mt.isWildcardType() || mediaType.isWildcardType()) {
            return true;
        }
        if (!mediaType.getType().equals(mt.getType())) {
            return false;
        }
        if (mt.isWildcardSubtype() || mt.isWildcardSubtype()) {
            return true;
        }
        if (mt.getSubtype().startsWith("*+")) {
            String compare = IgnoredMediaTypes.getSubtype(mt.getSubtype());
            String compare2 = IgnoredMediaTypes.getSubtype(mediaType.getSubtype());
            return compare.equals(compare2);
        }
        if (mt.getSubtype().endsWith("+*")) {
            String compare = IgnoredMediaTypes.getVendorString(mt.getSubtype());
            String compare2 = IgnoredMediaTypes.getVendorString(mediaType.getSubtype());
            return compare.equals(compare2);
        }
        return mt.getSubtype().equals(mediaType.getSubtype());
    }

    public static void main(String[] args) {
        System.out.println(IgnoredMediaTypes.getVendorString("foo+json"));
        System.out.println(IgnoredMediaTypes.getSubtype("foo+json"));
    }
}

