/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.threads.AsyncFuture;

public abstract class AsyncFutureTask<T>
implements AsyncFuture<T> {
    private final Executor executor;
    private AsyncFuture.Status status;
    private Object result;
    private List<Reg<?>> listeners;

    private static TimeoutException operationTimedOut() {
        return new TimeoutException("Operation timed out");
    }

    private static CancellationException operationCancelled() {
        return new CancellationException("Operation was cancelled");
    }

    private static ExecutionException operationFailed(Throwable cause) {
        return new ExecutionException("Operation failed", cause);
    }

    private static IllegalStateException invalidState() {
        return new IllegalStateException("Invalid state entered");
    }

    protected AsyncFutureTask(Executor executor) {
        this.executor = executor;
        this.status = AsyncFuture.Status.WAITING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean setResult(T result) {
        List<Reg<?>> list;
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            if (this.status != AsyncFuture.Status.WAITING) {
                return false;
            }
            this.result = result;
            this.status = AsyncFuture.Status.COMPLETE;
            this.notifyAll();
            list = this.listeners;
            this.listeners = null;
        }
        if (list != null) {
            for (Reg<?> reg : list) {
                this.safeExecute(reg);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean setCancelled() {
        List<Reg<?>> list;
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            if (this.status != AsyncFuture.Status.WAITING) {
                return false;
            }
            this.status = AsyncFuture.Status.CANCELLED;
            this.notifyAll();
            list = this.listeners;
            this.listeners = null;
        }
        if (list != null) {
            for (Reg<?> reg : list) {
                this.safeExecute(reg);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean setFailed(Throwable cause) {
        List<Reg<?>> list;
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            if (this.status != AsyncFuture.Status.WAITING) {
                return false;
            }
            this.status = AsyncFuture.Status.FAILED;
            this.result = cause;
            this.notifyAll();
            list = this.listeners;
            this.listeners = null;
        }
        if (list != null) {
            for (Reg<?> reg : list) {
                this.safeExecute(reg);
            }
        }
        return true;
    }

    private <A> void safeExecute(Reg<A> reg) {
        try {
            this.executor.execute(reg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void asyncCancel(boolean interruptionDesired) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AsyncFuture.Status await() throws InterruptedException {
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            while (this.status == AsyncFuture.Status.WAITING) {
                this.wait();
            }
            return this.status;
        }
    }

    @Override
    public final AsyncFuture.Status await(long timeout, TimeUnit unit) throws InterruptedException {
        long remaining = unit.toNanos(timeout);
        long now = System.nanoTime();
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            while (true) {
                AsyncFuture.Status status = this.status;
                if (remaining <= 0L || status != AsyncFuture.Status.WAITING) {
                    return status;
                }
                this.wait(remaining / 1000000L, (int)(remaining % 100000L));
                long l = -now;
                now = System.nanoTime();
                remaining -= l + now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AsyncFuture.Status awaitUninterruptibly() {
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            boolean intr = Thread.interrupted();
            try {
                while (this.status == AsyncFuture.Status.WAITING) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.status;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final AsyncFuture.Status awaitUninterruptibly(long timeout, TimeUnit unit) {
        long remaining = unit.toNanos(timeout);
        long now = System.nanoTime();
        boolean intr = Thread.interrupted();
        try {
            AsyncFutureTask asyncFutureTask = this;
            synchronized (asyncFutureTask) {
                while (true) {
                    AsyncFuture.Status status = this.status;
                    if (remaining <= 0L || status != AsyncFuture.Status.WAITING) {
                        AsyncFuture.Status status2 = status;
                        return status2;
                    }
                    try {
                        this.wait(remaining / 1000000L, (int)(remaining % 100000L));
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                    long l = -now;
                    now = System.nanoTime();
                    remaining -= l + now;
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            switch (this.await()) {
                case CANCELLED: {
                    throw AsyncFutureTask.operationCancelled();
                }
                case FAILED: {
                    throw AsyncFutureTask.operationFailed((Throwable)this.result);
                }
                case COMPLETE: {
                    return (T)this.result;
                }
            }
            throw AsyncFutureTask.invalidState();
        }
    }

    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            switch (this.await(timeout, unit)) {
                case CANCELLED: {
                    throw AsyncFutureTask.operationCancelled();
                }
                case FAILED: {
                    throw AsyncFutureTask.operationFailed((Throwable)this.result);
                }
                case COMPLETE: {
                    return (T)this.result;
                }
                case WAITING: {
                    throw AsyncFutureTask.operationTimedOut();
                }
            }
            throw AsyncFutureTask.invalidState();
        }
    }

    @Override
    public final T getUninterruptibly() throws CancellationException, ExecutionException {
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            switch (this.awaitUninterruptibly()) {
                case CANCELLED: {
                    throw AsyncFutureTask.operationCancelled();
                }
                case FAILED: {
                    throw AsyncFutureTask.operationFailed((Throwable)this.result);
                }
                case COMPLETE: {
                    return (T)this.result;
                }
            }
            throw AsyncFutureTask.invalidState();
        }
    }

    @Override
    public final T getUninterruptibly(long timeout, TimeUnit unit) throws CancellationException, ExecutionException, TimeoutException {
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            switch (this.awaitUninterruptibly(timeout, unit)) {
                case CANCELLED: {
                    throw AsyncFutureTask.operationCancelled();
                }
                case FAILED: {
                    throw AsyncFutureTask.operationFailed((Throwable)this.result);
                }
                case COMPLETE: {
                    return (T)this.result;
                }
                case WAITING: {
                    throw AsyncFutureTask.operationTimedOut();
                }
            }
            throw AsyncFutureTask.invalidState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AsyncFuture.Status getStatus() {
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <A> void addListener(AsyncFuture.Listener<? super T, A> listener, A attachment) {
        AsyncFutureTask asyncFutureTask = this;
        synchronized (asyncFutureTask) {
            Reg reg = new Reg(listener, attachment);
            if (this.status == AsyncFuture.Status.WAITING) {
                if (this.listeners == null) {
                    this.listeners = new ArrayList();
                }
                this.listeners.add(reg);
            } else {
                this.safeExecute(reg);
            }
        }
    }

    @Override
    public final boolean cancel(boolean interruptionDesired) {
        this.asyncCancel(interruptionDesired);
        return this.awaitUninterruptibly() == AsyncFuture.Status.CANCELLED;
    }

    @Override
    public final boolean isCancelled() {
        return this.getStatus() == AsyncFuture.Status.CANCELLED;
    }

    @Override
    public final boolean isDone() {
        return this.getStatus() != AsyncFuture.Status.WAITING;
    }

    private final class Reg<A>
    implements Runnable {
        private final AsyncFuture.Listener<? super T, A> listener;
        private final A attachment;

        private Reg(AsyncFuture.Listener<? super T, A> listener, A attachment) {
            this.listener = listener;
            this.attachment = attachment;
        }

        @Override
        public void run() {
            switch (AsyncFutureTask.this.getStatus()) {
                case CANCELLED: {
                    this.listener.handleCancelled(AsyncFutureTask.this, this.attachment);
                    break;
                }
                case COMPLETE: {
                    this.listener.handleComplete(AsyncFutureTask.this, this.attachment);
                    break;
                }
                case FAILED: {
                    this.listener.handleFailed(AsyncFutureTask.this, (Throwable)AsyncFutureTask.this.result, this.attachment);
                }
            }
        }
    }
}

