/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworks;
import oshi.util.FileUtil;

public class LinuxNetworks
extends AbstractNetworks {
    private static final long serialVersionUID = 1L;

    @Override
    public void updateNetworkStats(NetworkIF netIF) {
        String txBytesPath = String.format("/sys/class/net/%s/statistics/tx_bytes", netIF.getName());
        String rxBytesPath = String.format("/sys/class/net/%s/statistics/rx_bytes", netIF.getName());
        String txPacketsPath = String.format("/sys/class/net/%s/statistics/tx_packets", netIF.getName());
        String rxPacketsPath = String.format("/sys/class/net/%s/statistics/rx_packets", netIF.getName());
        String speed = String.format("/sys/class/net/%s/speed", netIF.getName());
        netIF.setBytesSent(FileUtil.getLongFromFile(txBytesPath));
        netIF.setBytesRecv(FileUtil.getLongFromFile(rxBytesPath));
        netIF.setPacketsSent(FileUtil.getLongFromFile(txPacketsPath));
        netIF.setPacketsRecv(FileUtil.getLongFromFile(rxPacketsPath));
        netIF.setSpeed(FileUtil.getLongFromFile(speed));
    }
}

