/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.SyncedEntity;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="A resource type contains metadata about resources it defines. It contains \"configurationSchema\" and \"connectionConfigurationSchema\" data entities that can prescribe a JSON schema to which the configurations of the resources should conform.", parent=SyncedEntity.class)
public final class ResourceType
extends SyncedEntity<Blueprint, Update> {
    public static final SegmentType SEGMENT_TYPE = SegmentType.rt;

    private ResourceType() {
    }

    public ResourceType(CanonicalPath path, String identityHash, String contentHash, String syncHash) {
        super(path, identityHash, contentHash, syncHash);
    }

    public ResourceType(String name, CanonicalPath path, String identityHash, String contentHash, String syncHash) {
        super(name, path, identityHash, contentHash, syncHash);
    }

    public ResourceType(CanonicalPath path, String identityHash, String contentHash, String syncHash, Map<String, Object> properties) {
        super(path, identityHash, contentHash, syncHash, properties);
    }

    public ResourceType(String name, CanonicalPath path, String identityHash, String contentHash, String syncHash, Map<String, Object> properties) {
        super(name, path, identityHash, contentHash, syncHash, properties);
    }

    @Override
    public AbstractElement.Updater<Update, ResourceType> update() {
        return new AbstractElement.Updater<Update, ResourceType>(u -> new ResourceType(u.getName(), this.getPath(), this.getIdentityHash(), this.getContentHash(), this.getSyncHash(), u.getProperties()));
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitResourceType(this, parameter);
    }

    @ApiModel(value="ResourceTypeUpdate")
    public static final class Update
    extends Entity.Update {
        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null);
        }

        public Update(Map<String, Object> properties) {
            super(null, properties);
        }

        public Update(String name, Map<String, Object> properties) {
            super(name, properties);
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitResourceType(this, parameter);
        }

        public static final class Builder
        extends Entity.Update.Builder<Update, Builder> {
            @Override
            public Update build() {
                return new Update(this.name, this.properties);
            }
        }
    }

    @ApiModel(value="ResourceTypeBlueprint")
    public static final class Blueprint
    extends Entity.Blueprint {
        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
        }

        public Blueprint(String id) {
            this(id, Collections.emptyMap());
        }

        public Blueprint(String id, Map<String, Object> properties) {
            super(id, properties);
        }

        public Blueprint(String id, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, properties, outgoing, incoming);
        }

        public Blueprint(String id, String name, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, name, properties, outgoing, incoming);
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitResourceType(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.name, this.properties, this.outgoing, this.incoming);
            }
        }
    }
}

