/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentType;

public class MiscContentItem
extends ContentItem {
    private final String[] path;
    private final boolean isDirectory;
    private final boolean affectsRuntime;

    public MiscContentItem(String name, List<String> path, byte[] contentHash, boolean directory) {
        this(name, path.toArray(new String[path.size()]), contentHash, directory, false);
    }

    public MiscContentItem(String name, String[] path, byte[] contentHash) {
        this(name, path, contentHash, false, false);
    }

    public MiscContentItem(String name, String[] path, byte[] contentHash, boolean isDirectory, boolean affectsRuntime) {
        super(name, contentHash, ContentType.MISC);
        this.path = path;
        this.isDirectory = isDirectory;
        this.affectsRuntime = affectsRuntime;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isAffectsRuntime() {
        return this.affectsRuntime;
    }

    public String[] getPath() {
        return this.path;
    }

    @Override
    public String getRelativePath() {
        StringBuilder builder = new StringBuilder();
        for (String p : this.path) {
            builder.append(p).append("/");
        }
        builder.append(this.getName());
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(MiscContentItem.class.getSimpleName()).append("{");
        for (String path : this.getPath()) {
            builder.append(path).append("/");
        }
        builder.append(this.getName()).append("}");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.affectsRuntime ? 1231 : 1237);
        result = 31 * result + (this.isDirectory ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.path);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MiscContentItem other = (MiscContentItem)obj;
        if (this.affectsRuntime != other.affectsRuntime) {
            return false;
        }
        if (this.isDirectory != other.isDirectory) {
            return false;
        }
        return Arrays.equals(this.path, other.path);
    }
}

