/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ThreadsLogger;

public final class TimeSpec
implements Serializable {
    private static final long serialVersionUID = 5145007669106852119L;
    public static final TimeSpec DEFAULT_KEEPALIVE = new TimeSpec(TimeUnit.SECONDS, 30L);
    private final TimeUnit unit;
    private final long duration;

    public TimeSpec(TimeUnit unit, long duration) {
        if (unit == null) {
            throw ThreadsLogger.ROOT_LOGGER.nullUnit();
        }
        this.unit = unit;
        this.duration = duration;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getDuration() {
        return this.duration;
    }

    public long elementHash() {
        return Long.rotateLeft(this.duration, 3) ^ (long)this.unit.hashCode() & 0xFFFFFFFFL;
    }

    public boolean equals(Object obj) {
        return obj instanceof TimeSpec && this.equals((TimeSpec)obj);
    }

    public boolean equals(TimeSpec obj) {
        return obj != null && this.unit == obj.unit && this.duration == obj.duration;
    }

    public int hashCode() {
        return (int)this.elementHash();
    }
}

