/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.interceptors;

import javax.ejb.EJBException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.interceptors.InternalInvocationMarker;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.tx.OwnableReentrantLock;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class EntityBeanSynchronizationInterceptor
extends AbstractEJBInterceptor {
    public static final InterceptorFactory FACTORY = new ComponentInstanceInterceptorFactory(){

        protected Interceptor create(Component component, InterceptorFactoryContext context) {
            return new EntityBeanSynchronizationInterceptor();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        EntityBeanComponent component = EntityBeanSynchronizationInterceptor.getComponent(context, EntityBeanComponent.class);
        EntityBeanComponentInstance instance = (EntityBeanComponentInstance)((Object)context.getPrivateData(ComponentInstance.class));
        OwnableReentrantLock lock = instance.getLock();
        if (instance.getPrimaryKey() == null) {
            return context.proceed();
        }
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = component.getTransactionSynchronizationRegistry();
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.trace("Trying to acquire lock: " + lock + " for entity bean " + (Object)((Object)instance) + " during invocation: " + context);
        }
        Object lockOwner = this.getLockOwner(transactionSynchronizationRegistry);
        lock.lock(lockOwner);
        boolean syncRegistered = false;
        OwnableReentrantLock ownableReentrantLock = lock;
        synchronized (ownableReentrantLock) {
            Object object;
            block18: {
                if (instance.isReloadRequired()) {
                    instance.reload();
                }
                if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                    EjbLogger.ROOT_LOGGER.trace("Acquired lock: " + lock + " for entity bean instance: " + (Object)((Object)instance) + " during invocation: " + context);
                }
                if (context.getPrivateData(InternalInvocationMarker.class) == null && (instance.isRemoved() || instance.isDiscarded())) {
                    Object primaryKey = context.getPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
                    component.getCache().release(instance, true);
                    lock.unlock(lockOwner);
                    throw EjbLogger.ROOT_LOGGER.instanceWasRemoved(component.getComponentName(), primaryKey);
                }
                Object currentTransactionKey = null;
                try {
                    currentTransactionKey = transactionSynchronizationRegistry.getTransactionKey();
                    if (!instance.isSynchronizeRegistered()) {
                        if (currentTransactionKey != null) {
                            EntityBeanSynchronization entitySynchronization = new EntityBeanSynchronization(instance, lockOwner);
                            transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)entitySynchronization);
                            syncRegistered = true;
                            if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                                EjbLogger.ROOT_LOGGER.trace("Registered tx synchronization: " + entitySynchronization + " for tx: " + currentTransactionKey + " associated with stateful component instance: " + (Object)((Object)instance));
                            }
                        }
                        instance.setSynchronizationRegistered(true);
                    }
                    object = context.proceed();
                    if (currentTransactionKey == null) {
                        instance.store();
                        this.releaseInstance(instance, true);
                        break block18;
                    }
                    if (syncRegistered) break block18;
                    component.getCache().release(instance, true);
                    lock.unlock(lockOwner);
                }
                catch (Throwable throwable) {
                    if (currentTransactionKey == null) {
                        instance.store();
                        this.releaseInstance(instance, true);
                    } else if (!syncRegistered) {
                        component.getCache().release(instance, true);
                        lock.unlock(lockOwner);
                    }
                    throw throwable;
                }
            }
            return object;
        }
    }

    private void releaseInstance(EntityBeanComponentInstance instance, boolean success) {
        try {
            instance.getComponent().getCache().release(instance, success);
        }
        finally {
            instance.setSynchronizationRegistered(false);
            this.releaseLock(instance);
        }
    }

    private void releaseLock(EntityBeanComponentInstance instance) {
        instance.getLock().unlock(this.getLockOwner(instance.getComponent().getTransactionSynchronizationRegistry()));
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.tracef("Released lock: %s", instance.getLock());
        }
    }

    private Object getLockOwner(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Object owner = transactionSynchronizationRegistry.getTransactionKey();
        return owner != null ? owner : Thread.currentThread();
    }

    private class EntityBeanSynchronization
    implements Synchronization {
        private final EntityBeanComponentInstance componentInstance;
        private final Object lockOwner;

        EntityBeanSynchronization(EntityBeanComponentInstance componentInstance, Object lockOwner) {
            this.componentInstance = componentInstance;
            this.lockOwner = lockOwner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeCompletion() {
            try {
                CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.BEFORE_COMPLETION);
                Object object = this.componentInstance.getThreadLock();
                synchronized (object) {
                    try {
                        if (!this.componentInstance.isRemoved() && !this.componentInstance.isDiscarded() && this.componentInstance.getPrimaryKey() != null) {
                            this.componentInstance.store();
                        }
                    }
                    catch (Throwable t) {
                        this.handleThrowableInTxSync(this.componentInstance, t);
                    }
                }
            }
            finally {
                CurrentSynchronizationCallback.clear();
            }
        }

        public void afterCompletion(int status) {
            try {
                boolean success;
                boolean bl = success = status != 1 && status != 4 && status != 9;
                if (!success) {
                    this.componentInstance.setReloadRequired(true);
                }
                EntityBeanSynchronizationInterceptor.this.releaseInstance(this.componentInstance, success);
            }
            catch (Exception e) {
                EjbLogger.ROOT_LOGGER.exceptionReleasingEntity(e);
            }
        }

        private void handleThrowableInTxSync(EntityBeanComponentInstance instance, Throwable t) {
            EjbLogger.ROOT_LOGGER.discardingEntityComponent(instance, t);
            try {
                instance.discard();
            }
            finally {
                EntityBeanSynchronizationInterceptor.this.releaseLock(instance);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw (EJBException)new EJBException().initCause(t);
        }
    }
}

