/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import org.jboss.aesh.console.Buffer;

public class CursorPosition {
    private int row;
    private int column;

    public CursorPosition(int row, int column) {
        this.setRow(row);
        this.setColumn(column);
    }

    public void setPosition(CursorPosition cp) {
        this.setRow(cp.getRow());
        this.setColumn(cp.getColumn());
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void move(int row, int column) {
        this.row += row;
        this.column += column;
    }

    public char[] asAnsi() {
        return Buffer.printAnsi(this.row + ";" + this.column + "H");
    }

    public String toString() {
        return "CursorPosition{row=" + this.row + ", column=" + this.column + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CursorPosition)) {
            return false;
        }
        CursorPosition that = (CursorPosition)o;
        if (this.column != that.column) {
            return false;
        }
        return this.row == that.row;
    }

    public int hashCode() {
        int result = this.row;
        result = 31 * result + this.column;
        return result;
    }
}

