/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.extension.MonitorServiceAddStepHandler;
import org.hawkular.agent.monitor.extension.PlatformAttributes;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.wildfly.util.Util;
import org.hawkular.agent.wildfly.util.WildflyCompatibilityUtils;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class PlatformAdd
extends MonitorServiceAddStepHandler {
    public static final PlatformAdd INSTANCE = new PlatformAdd();

    private PlatformAdd() {
        super(PlatformAttributes.ATTRIBUTES);
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            return;
        }
        MonitorService monitorService = this.getMonitorService(context);
        if (monitorService == null) {
            return;
        }
        AgentCoreEngineConfiguration config = Util.getMonitorServiceConfiguration(context);
        ProtocolServices newServices = monitorService.createProtocolServicesBuilder().platformProtocolService(config.getPlatformConfiguration()).build();
        EndpointService endpointService = (EndpointService)newServices.getPlatformProtocolService().getEndpointServices().get(WildflyCompatibilityUtils.getCurrentAddressValue(context, operation));
        ProtocolService platformService = monitorService.getProtocolServices().getPlatformProtocolService();
        platformService.add(endpointService);
    }
}

