/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.SecurityActions;

public class ContextClassLoaderSetupAction
implements ThreadSetupAction {
    private final ClassLoader classLoader;

    public ContextClassLoaderSetupAction(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
        final ClassLoader old = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.classLoader);
        return new ThreadSetupAction.Handle(){

            @Override
            public void tearDown() {
                SecurityActions.setContextClassLoader(old);
            }
        };
    }
}

