/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addressRewrite;

import java.util.HashMap;
import java.util.Map;

final class CharMap {
    private final char[] map = new char[256];
    private final Map<Character, Character> extendedMap = new HashMap<Character, Character>();

    public CharMap(String source, String destination) {
        this.add(source, destination);
    }

    private void add(String source, String destination) {
        int len = Math.min(source.length(), destination.length());
        for (int i = 0; i < len; ++i) {
            this.add(source.charAt(i), destination.charAt(i));
        }
    }

    private void add(char source, char destination) {
        if (destination == '\u0000') {
            throw new IllegalArgumentException("cannot map to zero character");
        }
        if (source < '\u0100') {
            this.map[source] = destination;
        } else {
            this.extendedMap.put(Character.valueOf(source), Character.valueOf(destination));
        }
    }

    public char map(char source) {
        if (source < '\u0100') {
            return this.map[source];
        }
        Character mapped = this.extendedMap.get(Character.valueOf(source));
        return mapped == null ? (char)'\u0000' : mapped.charValue();
    }
}

