/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Serializable;
import java.util.Arrays;
import org.jboss.ejb.client.ArrayUtil;
import org.jboss.ejb.client.UserTransactionID;
import org.jboss.ejb.client.XidTransactionID;

public abstract class TransactionID
implements Serializable {
    private static final long serialVersionUID = 7711835471353644411L;
    private final byte[] encodedForm;
    private final transient int hashCode;
    public static final String PRIVATE_DATA_KEY = "jboss.transaction.id";

    TransactionID(byte[] encodedForm) {
        this.encodedForm = encodedForm;
        this.hashCode = Arrays.hashCode(encodedForm);
    }

    public byte[] getEncodedForm() {
        return (byte[])this.encodedForm.clone();
    }

    protected byte[] getEncodedFormRaw() {
        return this.encodedForm;
    }

    public final boolean equals(Object other) {
        return other.getClass() == this.getClass() && this.equals((TransactionID)other);
    }

    private boolean equals(TransactionID other) {
        return this == other || other != null && Arrays.equals(this.encodedForm, other.encodedForm);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.format("%s [%s]", this.getClass().getSimpleName(), ArrayUtil.bytesToString(this.encodedForm, 0, this.encodedForm.length));
    }

    public static TransactionID createTransactionID(byte[] encoded) {
        int length = encoded.length;
        if (length > 0) {
            switch (encoded[0]) {
                case 1: {
                    return new UserTransactionID((byte[])encoded.clone());
                }
                case 2: {
                    return new XidTransactionID((byte[])encoded.clone());
                }
            }
        }
        throw new IllegalArgumentException("Unrecognized Transaction ID format");
    }

    protected final Object writeReplace() {
        return new Serialized(this.encodedForm);
    }

    public static final class Serialized
    implements Serializable {
        private static final long serialVersionUID = -8146407206244018476L;
        private final byte[] id;

        Serialized(byte[] id) {
            this.id = id;
        }

        protected Object readResolve() {
            return TransactionID.createTransactionID(this.id);
        }
    }
}

