/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.hawkular.agent.monitor.cmd.AbstractResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.inventory.InventoryIdUtil;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.MessageUtils;
import org.hawkular.cmdgw.api.ResourcePathRequest;
import org.hawkular.cmdgw.api.ResourcePathResponse;
import org.hawkular.cmdgw.api.ResponseStatus;
import org.hawkular.inventory.paths.CanonicalPath;

public abstract class AbstractJMXResourcePathCommand<REQ extends ResourcePathRequest, RESP extends ResourcePathResponse>
extends AbstractResourcePathCommand<REQ, RESP> {
    private static final MsgLogger log = AgentLoggers.getLogger(AbstractJMXResourcePathCommand.class);

    public AbstractJMXResourcePathCommand(String operationName, String entityType) {
        super(operationName, entityType);
    }

    @Override
    public BasicMessageWithExtraData<RESP> execute(BasicMessageWithExtraData<REQ> envelope, CommandContext context) throws Exception {
        ResourcePathRequest request = (ResourcePathRequest)envelope.getBasicMessage();
        String rawResourcePath = request.getResourcePath();
        log.infoReceivedResourcePathCommand(this.getOperationName(envelope), this.getEntityType(envelope), rawResourcePath);
        Object response = this.createResponse();
        MessageUtils.prepareResourcePathResponse((ResourcePathRequest)request, response);
        BinaryData binaryData = null;
        long timestampBeforeExecution = System.currentTimeMillis();
        try {
            String resourceId;
            this.validate(envelope);
            CanonicalPath canonicalPath = CanonicalPath.fromString((String)rawResourcePath);
            try {
                resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Bad resource path specified in command: " + rawResourcePath);
            }
            InventoryIdUtil.ResourceIdParts idParts = InventoryIdUtil.parseResourceId(resourceId);
            String managedServerName = idParts.getManagedServerName();
            EndpointService<JMXNodeLocation, JMXSession> endpointService = context.getAgentCoreEngine().getProtocolServices().getJmxProtocolService().getEndpointServices().get(managedServerName);
            if (endpointService == null) {
                throw new IllegalArgumentException(String.format("Cannot perform [%s] on a [%s] given by inventory path [%s]: unknown managed server [%s]", this.getOperationName(envelope), this.getEntityType(envelope), resourceId, managedServerName));
            }
            if (this.modifiesResource() && context.getAgentCoreEngine().isImmutable()) {
                throw new IllegalStateException("Command not allowed because the agent is immutable");
            }
            binaryData = this.execute(endpointService, resourceId, envelope, response, context);
            this.success(envelope, response);
        }
        catch (Throwable t) {
            response.setStatus(ResponseStatus.ERROR);
            String formattedTimestamp = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mmX").withZone(ZoneOffset.UTC).format(Instant.ofEpochMilli(timestampBeforeExecution));
            String msg = String.format("Could not perform [%s] on a [%s] given by inventory path [%s] requested on [%s]: %s", this.getOperationName(envelope), this.getEntityType(envelope), rawResourcePath, formattedTimestamp, t.toString());
            response.setMessage(msg);
            log.debug(msg, t);
        }
        return new BasicMessageWithExtraData(response, binaryData);
    }

    protected abstract BinaryData execute(EndpointService<JMXNodeLocation, JMXSession> var1, String var2, BasicMessageWithExtraData<REQ> var3, RESP var4, CommandContext var5) throws Exception;
}

