/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;

abstract class MutabilityChecker {
    MutabilityChecker() {
    }

    abstract boolean mutable(PathAddress var1);

    static MutabilityChecker create(ProcessType processType, boolean isMasterHc) {
        if (processType == ProcessType.STANDALONE_SERVER) {
            return new StandaloneServerChecker();
        }
        if (processType == ProcessType.HOST_CONTROLLER) {
            return new HostControllerChecker(isMasterHc);
        }
        return new NonMutableChecker();
    }

    private static class HostControllerChecker
    extends MutabilityChecker {
        private final boolean isMaster;

        public HostControllerChecker(boolean isMaster) {
            this.isMaster = isMaster;
        }

        @Override
        boolean mutable(PathAddress address) {
            return false;
        }
    }

    private static class NonMutableChecker
    extends MutabilityChecker {
        private NonMutableChecker() {
        }

        @Override
        boolean mutable(PathAddress address) {
            return false;
        }
    }

    private static class StandaloneServerChecker
    extends MutabilityChecker {
        private StandaloneServerChecker() {
        }

        @Override
        boolean mutable(PathAddress address) {
            return true;
        }
    }
}

