/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.wildfly.util;

import java.util.ArrayList;
import java.util.Collection;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.extension.MonitorServiceConfigurationBuilder;
import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.wildfly.util.WildflyCompatibilityUtils;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class Util {
    public static void registerOnlyRestartAttributes(ManagementResourceRegistration resourceRegistration, Collection<AttributeDefinition> allAttributes) {
        ArrayList<AttributeDefinition> restartResourceServicesAttributes = new ArrayList<AttributeDefinition>();
        ArrayList<AttributeDefinition> restartAllServicesAttributes = new ArrayList<AttributeDefinition>();
        for (AttributeDefinition attribDef : allAttributes) {
            if (attribDef.getFlags().contains(AttributeAccess.Flag.RESTART_JVM) || attribDef.getFlags().contains(AttributeAccess.Flag.RESTART_ALL_SERVICES)) {
                restartAllServicesAttributes.add(attribDef);
                continue;
            }
            if (!attribDef.getFlags().contains(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)) continue;
            restartResourceServicesAttributes.add(attribDef);
        }
        class CustomWriteAttributeHandler
        extends ReloadRequiredWriteAttributeHandler {
            public CustomWriteAttributeHandler(Collection<AttributeDefinition> attribs) {
                super(attribs);
            }

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (!context.isBooting()) {
                    ServiceName name = SubsystemExtension.SERVICE_NAME;
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
                    MonitorService agent = (MonitorService)((Object)serviceRegistry.getRequiredService(name).getValue());
                    if (agent.isImmutable()) {
                        throw new OperationFailedException("The agent is configured to be immutable - no changes are allowed.");
                    }
                }
                super.execute(context, operation);
            }
        }
        CustomWriteAttributeHandler handler = new CustomWriteAttributeHandler(restartAllServicesAttributes);
        WildflyCompatibilityUtils.EAP6MonitorServiceRestartParentAttributeHandler restartParentHandler = new WildflyCompatibilityUtils.EAP6MonitorServiceRestartParentAttributeHandler(restartResourceServicesAttributes);
        for (AttributeDefinition attribDef : restartAllServicesAttributes) {
            resourceRegistration.registerReadWriteAttribute(attribDef, null, (OperationStepHandler)handler);
        }
        for (AttributeDefinition attribDef : restartResourceServicesAttributes) {
            resourceRegistration.registerReadWriteAttribute(attribDef, null, (OperationStepHandler)restartParentHandler);
        }
    }

    public static AgentCoreEngineConfiguration getMonitorServiceConfiguration(OperationContext context) throws OperationFailedException {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"hawkular-wildfly-agent")});
        ModelNode subsystemConfig = Resource.Tools.readModel((Resource)context.readResourceFromRoot(subsystemAddress));
        AgentCoreEngineConfiguration config = new MonitorServiceConfigurationBuilder(subsystemConfig, context).build();
        return config;
    }
}

