/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.impl;

import org.wildfly.extension.batch.jberet.impl.ContextHandle;
import org.wildfly.security.manager.WildFlySecurityManager;

class ClassLoaderContextHandle
implements ContextHandle {
    private final ClassLoader classLoader;

    ClassLoaderContextHandle(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ContextHandle.Handle setup() {
        final ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
        return new ContextHandle.Handle(){

            @Override
            public void tearDown() {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
            }
        };
    }
}

