/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.api;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.hawkular.cmdgw.api.Authentication;
import org.hawkular.cmdgw.api.GenericErrorResponse;

public class GenericErrorResponseBuilder {
    private final GenericErrorResponse response = new GenericErrorResponse();

    public static GenericErrorResponse buildWithThrowable(Throwable t) {
        return new GenericErrorResponseBuilder().setThrowable(t).build();
    }

    public GenericErrorResponse build() {
        return this.response;
    }

    public GenericErrorResponseBuilder setErrorMessage(String errorMessage) {
        this.response.setErrorMessage(errorMessage);
        return this;
    }

    public GenericErrorResponseBuilder setStackTrace(String stackTrace) {
        this.response.setStackTrace(stackTrace);
        return this;
    }

    public GenericErrorResponseBuilder setUsername(String username) {
        this.populateAuthentication().setUsername(username);
        return this;
    }

    public GenericErrorResponseBuilder setPassword(String password) {
        this.populateAuthentication().setPassword(password);
        return this;
    }

    public GenericErrorResponseBuilder setToken(String token) {
        this.populateAuthentication().setToken(token);
        return this;
    }

    public GenericErrorResponseBuilder setPersona(String persona) {
        this.populateAuthentication().setPersona(persona);
        return this;
    }

    public GenericErrorResponseBuilder setThrowable(Throwable t) {
        this.setErrorMessage(t.getMessage());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(baos);){
            t.printStackTrace(pw);
        }
        this.setStackTrace(baos.toString());
        return this;
    }

    private Authentication populateAuthentication() {
        Authentication auth = this.response.getAuthentication();
        if (auth == null) {
            auth = new Authentication();
            this.response.setAuthentication(auth);
        }
        return auth;
    }
}

