/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.works.AddWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.UpdateWorkExecutor;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class UpdateExtWorkExecutor
extends UpdateWorkExecutor {
    private static final Log log = LoggerFactory.make();
    private final AddWorkExecutor addDelegate;
    private final Class<?> managedType;
    private final DocumentBuilderIndexedEntity builder;
    private final boolean idIsNumeric;
    private final Workspace workspace;

    UpdateExtWorkExecutor(Workspace workspace, AddWorkExecutor addDelegate) {
        super(null, null);
        this.workspace = workspace;
        this.addDelegate = addDelegate;
        this.managedType = workspace.getEntitiesInIndexManager().iterator().next();
        this.builder = workspace.getDocumentBuilder(this.managedType);
        this.idIsNumeric = DeleteWorkExecutor.isIdNumeric(this.builder);
    }

    @Override
    public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        this.checkType(work);
        Serializable id = work.getId();
        try {
            if (this.idIsNumeric) {
                log.tracef("Deleting %s#%s by query using an IndexWriter#updateDocument as id is Numeric", this.managedType, id);
                delegate.deleteDocuments(NumericFieldUtils.createExactMatchQuery(this.builder.getIdKeywordName(), id));
                this.addDelegate.performWork(work, delegate, monitor);
            } else {
                log.tracef("Updating %s#%s by id using an IndexWriter#updateDocument.", this.managedType, id);
                Term idTerm = new Term(this.builder.getIdKeywordName(), work.getIdInString());
                Map<String, String> fieldToAnalyzerMap = work.getFieldToAnalyzerMap();
                ScopedAnalyzer analyzer = this.builder.getAnalyzer();
                analyzer = AddWorkExecutor.updateAnalyzerMappings(this.workspace, analyzer, fieldToAnalyzerMap);
                delegate.updateDocument(idTerm, work.getDocument(), analyzer);
            }
            this.workspace.notifyWorkApplied(work);
        }
        catch (Exception e) {
            String message = "Unable to update " + this.managedType + "#" + id + " in index.";
            throw new SearchException(message, e);
        }
        if (monitor != null) {
            monitor.documentsAdded(1L);
        }
    }

    private void checkType(LuceneWork work) {
        if (work.getEntityClass() != this.managedType) {
            throw new AssertionFailure("Unexpected type: " + work.getEntityClass() + " This workspace expects: " + this.managedType);
        }
    }
}

