/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.security.JASPIMappingModuleDefinition;
import org.jboss.as.security.JSSEResourceDefinition;
import org.jboss.as.security.LoginModuleResourceDefinition;
import org.jboss.as.security.MappingModuleDefinition;
import org.jboss.as.security.ModuleFlag;
import org.jboss.as.security.ModulesMap;
import org.jboss.as.security.SecurityDomainResourceDefinition;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.service.JaasConfigurationService;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.as.security.service.SecurityManagementService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.JBossJSSESecurityDomain;
import org.jboss.security.JSSESecurityDomain;
import org.jboss.security.acl.config.ACLProviderEntry;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.ACLInfo;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
import org.jboss.security.mapping.MappingType;
import org.jboss.security.mapping.config.MappingModuleEntry;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;

class SecurityDomainAdd
extends AbstractAddStepHandler {
    private static final String CACHE_CONTAINER_NAME = "security";
    static final SecurityDomainAdd INSTANCE = new SecurityDomainAdd();

    private SecurityDomainAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        SecurityDomainResourceDefinition.CACHE_TYPE.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        final String securityDomain = address.getLastElement().getValue();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                SecurityDomainAdd.this.launchServices(context, securityDomain, Resource.Tools.readModel((Resource)resource));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    public void launchServices(OperationContext context, String securityDomain, ModelNode model) throws OperationFailedException {
        ApplicationPolicy applicationPolicy = this.createApplicationPolicy(context, securityDomain, model);
        JSSESecurityDomain jsseSecurityDomain = this.createJSSESecurityDomain(context, securityDomain, model);
        String cacheType = SecurityDomainAdd.getAuthenticationCacheType(model);
        SecurityDomainService securityDomainService = new SecurityDomainService(securityDomain, applicationPolicy, jsseSecurityDomain, cacheType);
        ServiceTarget target = context.getServiceTarget();
        ServiceBuilder builder = target.addService(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}), (Service)securityDomainService).addDependency(SecurityManagementService.SERVICE_NAME, ISecurityManagement.class, securityDomainService.getSecurityManagementInjector()).addDependency(JaasConfigurationService.SERVICE_NAME, Configuration.class, securityDomainService.getConfigurationInjector());
        if ("infinispan".equals(cacheType)) {
            builder.addDependency(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(CACHE_CONTAINER_NAME), Object.class, securityDomainService.getCacheManagerInjector());
        }
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private ApplicationPolicy createApplicationPolicy(OperationContext context, String securityDomain, ModelNode model) throws OperationFailedException {
        ApplicationPolicy applicationPolicy = new ApplicationPolicy(securityDomain);
        boolean create = this.processClassicAuth(context, securityDomain, model, applicationPolicy);
        create |= this.processJASPIAuth(context, securityDomain, model, applicationPolicy);
        create |= this.processAuthorization(context, securityDomain, model, applicationPolicy);
        create |= this.processACL(context, securityDomain, model, applicationPolicy);
        create |= this.processAudit(context, securityDomain, model, applicationPolicy);
        create |= this.processIdentityTrust(context, securityDomain, model, applicationPolicy);
        return (create |= this.processMapping(context, securityDomain, model, applicationPolicy)) ? applicationPolicy : null;
    }

    private boolean processMapping(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "mapping", "classic", "mapping-module")) == null) {
            return false;
        }
        for (Property moduleProperty : node.asPropertyList()) {
            ModelNode module = moduleProperty.getValue();
            MappingInfo mappingInfo = new MappingInfo(securityDomain);
            String codeName = SecurityDomainAdd.extractCode(context, module, ModulesMap.MAPPING_MAP);
            String mappingType = module.hasDefined("type") ? MappingModuleDefinition.TYPE.resolveModelAttribute(context, module).asString() : MappingType.ROLE.toString();
            Map<String, Object> options = this.extractOptions(context, module);
            MappingModuleEntry entry = new MappingModuleEntry(codeName, options, mappingType);
            mappingInfo.add((Object)entry);
            applicationPolicy.setMappingInfo(mappingType, mappingInfo);
            ModelNode moduleName = LoginModuleResourceDefinition.MODULE.resolveModelAttribute(context, module);
            if (!moduleName.isDefined() || moduleName.asString().length() <= 0) continue;
            mappingInfo.setJBossModuleName(moduleName.asString());
        }
        return true;
    }

    private boolean processIdentityTrust(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "identity-trust", "classic", "trust-module")) == null) {
            return false;
        }
        IdentityTrustInfo identityTrustInfo = new IdentityTrustInfo(securityDomain);
        for (Property moduleProperty : node.asPropertyList()) {
            ModelNode module = moduleProperty.getValue();
            String codeName = LoginModuleResourceDefinition.CODE.resolveModelAttribute(context, module).asString();
            String flag = LoginModuleResourceDefinition.FLAG.resolveModelAttribute(context, module).asString();
            ControlFlag controlFlag = ControlFlag.valueOf((String)flag);
            Map<String, Object> options = this.extractOptions(context, module);
            IdentityTrustModuleEntry entry = new IdentityTrustModuleEntry(codeName, options);
            entry.setControlFlag(controlFlag);
            identityTrustInfo.add((Object)entry);
            ModelNode moduleName = LoginModuleResourceDefinition.MODULE.resolveModelAttribute(context, module);
            if (!moduleName.isDefined() || moduleName.asString().length() <= 0) continue;
            identityTrustInfo.setJBossModuleName(moduleName.asString());
        }
        applicationPolicy.setIdentityTrustInfo(identityTrustInfo);
        return true;
    }

    private boolean processAudit(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "audit", "classic", "provider-module")) == null) {
            return false;
        }
        AuditInfo auditInfo = new AuditInfo(securityDomain);
        for (Property moduleProperty : node.asPropertyList()) {
            ModelNode module = moduleProperty.getValue();
            String codeName = LoginModuleResourceDefinition.CODE.resolveModelAttribute(context, module).asString();
            Map<String, Object> options = this.extractOptions(context, module);
            AuditProviderEntry entry = new AuditProviderEntry(codeName, options);
            auditInfo.add((Object)entry);
            ModelNode moduleName = LoginModuleResourceDefinition.MODULE.resolveModelAttribute(context, module);
            if (!moduleName.isDefined() || moduleName.asString().length() <= 0) continue;
            auditInfo.setJBossModuleName(moduleName.asString());
        }
        applicationPolicy.setAuditInfo(auditInfo);
        return true;
    }

    private boolean processACL(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "acl", "classic", "acl-module")) == null) {
            return false;
        }
        ACLInfo aclInfo = new ACLInfo(securityDomain);
        for (Property moduleProperty : node.asPropertyList()) {
            ModelNode module = moduleProperty.getValue();
            String codeName = LoginModuleResourceDefinition.CODE.resolveModelAttribute(context, module).asString();
            String flag = LoginModuleResourceDefinition.FLAG.resolveModelAttribute(context, module).asString();
            ControlFlag controlFlag = ControlFlag.valueOf((String)flag);
            Map<String, Object> options = this.extractOptions(context, module);
            ACLProviderEntry entry = new ACLProviderEntry(codeName, options);
            entry.setControlFlag(controlFlag);
            aclInfo.add((Object)entry);
            ModelNode moduleName = LoginModuleResourceDefinition.MODULE.resolveModelAttribute(context, module);
            if (!moduleName.isDefined() || moduleName.asString().length() <= 0) continue;
            aclInfo.setJBossModuleName(moduleName.asString());
        }
        applicationPolicy.setAclInfo(aclInfo);
        return true;
    }

    private boolean processAuthorization(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "authorization", "classic", "policy-module")) == null) {
            return false;
        }
        AuthorizationInfo authzInfo = new AuthorizationInfo(securityDomain);
        for (Property moduleProperty : node.asPropertyList()) {
            ModelNode module = moduleProperty.getValue();
            String codeName = SecurityDomainAdd.extractCode(context, module, ModulesMap.AUTHORIZATION_MAP);
            String flag = LoginModuleResourceDefinition.FLAG.resolveModelAttribute(context, module).asString();
            ControlFlag controlFlag = ControlFlag.valueOf((String)flag);
            Map<String, Object> options = this.extractOptions(context, module);
            AuthorizationModuleEntry authzModuleEntry = new AuthorizationModuleEntry(codeName, options);
            authzModuleEntry.setControlFlag(controlFlag);
            authzInfo.add((Object)authzModuleEntry);
            ModelNode moduleName = LoginModuleResourceDefinition.MODULE.resolveModelAttribute(context, module);
            if (!moduleName.isDefined() || moduleName.asString().length() <= 0) continue;
            authzInfo.setJBossModuleName(moduleName.asString());
        }
        applicationPolicy.setAuthorizationInfo(authzInfo);
        return true;
    }

    private boolean processJASPIAuth(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "authentication", "jaspi")) == null) {
            return false;
        }
        JASPIAuthenticationInfo authenticationInfo = new JASPIAuthenticationInfo(securityDomain);
        HashMap<String, LoginModuleStackHolder> holders = new HashMap<String, LoginModuleStackHolder>();
        if (node.hasDefined("login-module-stack")) {
            List stacks = node.get("login-module-stack").asPropertyList();
            for (Property stack : stacks) {
                String name = stack.getName();
                ModelNode stackNode = stack.getValue();
                final LoginModuleStackHolder holder = new LoginModuleStackHolder(name, null);
                holders.put(name, holder);
                authenticationInfo.add(holder);
                if (!stackNode.hasDefined("login-module")) continue;
                this.processLoginModules(context, stackNode.get("login-module"), (BaseAuthenticationInfo)authenticationInfo, new LoginModuleContainer(){

                    @Override
                    public void addAppConfigurationEntry(AppConfigurationEntry entry) {
                        holder.addAppConfigurationEntry(entry);
                    }
                });
            }
        }
        for (Property moduleProperty : node.get("auth-module").asPropertyList()) {
            ModelNode authModule = moduleProperty.getValue();
            String code = SecurityDomainAdd.extractCode(context, authModule, ModulesMap.AUTHENTICATION_MAP);
            String loginStackRef = null;
            if (authModule.hasDefined("login-module-stack-ref")) {
                loginStackRef = JASPIMappingModuleDefinition.LOGIN_MODULE_STACK_REF.resolveModelAttribute(context, authModule).asString();
            }
            Map<String, Object> options = this.extractOptions(context, authModule);
            AuthModuleEntry entry = new AuthModuleEntry(code, options, loginStackRef);
            if (authModule.hasDefined("flag")) {
                String flag = LoginModuleResourceDefinition.FLAG.resolveModelAttribute(context, authModule).asString();
                entry.setControlFlag(ControlFlag.valueOf((String)flag));
            }
            if (loginStackRef != null) {
                if (!holders.containsKey(loginStackRef)) {
                    throw SecurityLogger.ROOT_LOGGER.loginModuleStackIllegalArgument(loginStackRef);
                }
                entry.setLoginModuleStackHolder((LoginModuleStackHolder)holders.get(loginStackRef));
            }
            authenticationInfo.add(entry);
            ModelNode moduleName = LoginModuleResourceDefinition.MODULE.resolveModelAttribute(context, authModule);
            if (!moduleName.isDefined() || moduleName.asString().length() <= 0) continue;
            authenticationInfo.setJBossModuleName(moduleName.asString());
        }
        applicationPolicy.setAuthenticationInfo((BaseAuthenticationInfo)authenticationInfo);
        return true;
    }

    private static String extractCode(OperationContext context, ModelNode node, Map<String, String> substitutions) throws OperationFailedException {
        String code = LoginModuleResourceDefinition.CODE.resolveModelAttribute(context, node).asString();
        if (substitutions.containsKey(code)) {
            code = substitutions.get(code);
        }
        return code;
    }

    private ModelNode peek(ModelNode node, String ... args) {
        for (String arg : args) {
            if (!node.hasDefined(arg)) {
                return null;
            }
            node = node.get(arg);
        }
        return node;
    }

    private boolean processClassicAuth(OperationContext context, String securityDomain, ModelNode node, ApplicationPolicy applicationPolicy) throws OperationFailedException {
        if ((node = this.peek(node, "authentication", "classic")) == null) {
            return false;
        }
        final AuthenticationInfo authenticationInfo = new AuthenticationInfo(securityDomain);
        if (node.hasDefined("login-module")) {
            this.processLoginModules(context, node.get("login-module"), (BaseAuthenticationInfo)authenticationInfo, new LoginModuleContainer(){

                @Override
                public void addAppConfigurationEntry(AppConfigurationEntry entry) {
                    authenticationInfo.add((Object)entry);
                }
            });
        }
        applicationPolicy.setAuthenticationInfo((BaseAuthenticationInfo)authenticationInfo);
        return true;
    }

    private void processLoginModules(OperationContext context, ModelNode node, BaseAuthenticationInfo authInfo, LoginModuleContainer container) throws OperationFailedException {
        for (Property moduleProperty : node.asPropertyList()) {
            ModelNode module = moduleProperty.getValue();
            String codeName = SecurityDomainAdd.extractCode(context, module, ModulesMap.AUTHENTICATION_MAP);
            String flag = LoginModuleResourceDefinition.FLAG.resolveModelAttribute(context, module).asString();
            AppConfigurationEntry.LoginModuleControlFlag controlFlag = this.getControlFlag(flag);
            Map<String, Object> options = this.extractOptions(context, module);
            AppConfigurationEntry entry = new AppConfigurationEntry(codeName, controlFlag, options);
            container.addAppConfigurationEntry(entry);
            ModelNode moduleName = LoginModuleResourceDefinition.MODULE.resolveModelAttribute(context, module);
            if (!moduleName.isDefined() || moduleName.asString().length() <= 0) continue;
            authInfo.setJBossModuleName(moduleName.asString());
        }
    }

    private Map<String, Object> extractOptions(OperationContext context, ModelNode module) throws OperationFailedException {
        return new LinkedHashMap<String, Object>(MappingModuleDefinition.MODULE_OPTIONS.unwrap((ExpressionResolver)context, module));
    }

    private JSSESecurityDomain createJSSESecurityDomain(OperationContext context, String securityDomain, ModelNode node) throws OperationFailedException {
        String value;
        if ((node = this.peek(node, "jsse", "classic")) == null) {
            return null;
        }
        final JBossJSSESecurityDomain jsseSecurityDomain = new JBossJSSESecurityDomain(securityDomain);
        this.processKeyStore(context, node, "keystore", new KeyStoreConfig(){

            @Override
            public void setKeyStorePassword(String value) throws Exception {
                jsseSecurityDomain.setKeyStorePassword(value);
            }

            @Override
            public void setKeyStoreType(String value) {
                jsseSecurityDomain.setKeyStoreType(value);
            }

            @Override
            public void setKeyStoreURL(String value) throws IOException {
                jsseSecurityDomain.setKeyStoreURL(value);
            }

            @Override
            public void setKeyStoreProvider(String value) {
                jsseSecurityDomain.setKeyStoreProvider(value);
            }

            @Override
            public void setKeyStoreProviderArgument(String value) {
                jsseSecurityDomain.setKeyStoreProviderArgument(value);
            }
        });
        this.processKeyStore(context, node, "truststore", new KeyStoreConfig(){

            @Override
            public void setKeyStorePassword(String value) throws Exception {
                jsseSecurityDomain.setTrustStorePassword(value);
            }

            @Override
            public void setKeyStoreType(String value) {
                jsseSecurityDomain.setTrustStoreType(value);
            }

            @Override
            public void setKeyStoreURL(String value) throws IOException {
                jsseSecurityDomain.setTrustStoreURL(value);
            }

            @Override
            public void setKeyStoreProvider(String value) {
                jsseSecurityDomain.setTrustStoreProvider(value);
            }

            @Override
            public void setKeyStoreProviderArgument(String value) {
                jsseSecurityDomain.setTrustStoreProviderArgument(value);
            }
        });
        this.processKeyManager(context, node, "key-manager", new KeyManagerConfig(){

            @Override
            public void setKeyManagerFactoryAlgorithm(String value) {
                jsseSecurityDomain.setKeyManagerFactoryAlgorithm(value);
            }

            @Override
            public void setKeyManagerFactoryProvider(String value) {
                jsseSecurityDomain.setKeyManagerFactoryProvider(value);
            }
        });
        this.processKeyManager(context, node, "trust-manager", new KeyManagerConfig(){

            @Override
            public void setKeyManagerFactoryAlgorithm(String value) {
                jsseSecurityDomain.setTrustManagerFactoryAlgorithm(value);
            }

            @Override
            public void setKeyManagerFactoryProvider(String value) {
                jsseSecurityDomain.setTrustManagerFactoryProvider(value);
            }
        });
        if (node.hasDefined("client-alias")) {
            value = JSSEResourceDefinition.CLIENT_ALIAS.resolveModelAttribute(context, node).asString();
            jsseSecurityDomain.setClientAlias(value);
        }
        if (node.hasDefined("server-alias")) {
            value = JSSEResourceDefinition.SERVER_ALIAS.resolveModelAttribute(context, node).asString();
            jsseSecurityDomain.setServerAlias(value);
        }
        if (node.hasDefined("client-auth")) {
            boolean clientAuth = JSSEResourceDefinition.CLIENT_AUTH.resolveModelAttribute(context, node).asBoolean();
            jsseSecurityDomain.setClientAuth(clientAuth);
        }
        if (node.hasDefined("service-auth-token")) {
            value = JSSEResourceDefinition.SERVICE_AUTH_TOKEN.resolveModelAttribute(context, node).asString();
            try {
                jsseSecurityDomain.setServiceAuthToken(value);
            }
            catch (Exception e) {
                throw SecurityLogger.ROOT_LOGGER.runtimeException(e);
            }
        }
        if (node.hasDefined("cipher-suites")) {
            value = JSSEResourceDefinition.CIPHER_SUITES.resolveModelAttribute(context, node).asString();
            jsseSecurityDomain.setCipherSuites(value);
        }
        if (node.hasDefined("protocols")) {
            value = JSSEResourceDefinition.PROTOCOLS.resolveModelAttribute(context, node).asString();
            jsseSecurityDomain.setProtocols(value);
        }
        if (node.hasDefined("additional-properties")) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)JSSEResourceDefinition.ADDITIONAL_PROPERTIES.unwrap((ExpressionResolver)context, node));
            jsseSecurityDomain.setAdditionalProperties(properties);
        }
        return jsseSecurityDomain;
    }

    private void processKeyStore(OperationContext context, ModelNode node, String name, KeyStoreConfig config) throws OperationFailedException {
        ModelNode value = this.peek(node, name, "password");
        ModelNode type = this.peek(node, name, "type");
        ModelNode url = this.peek(node, name, "url");
        ModelNode provider = this.peek(node, name, "provider");
        ModelNode providerArgument = this.peek(node, name, "provider-argument");
        if (value != null) {
            try {
                config.setKeyStorePassword(context.resolveExpressions(value).asString());
            }
            catch (Exception e) {
                throw SecurityLogger.ROOT_LOGGER.runtimeException(e);
            }
        }
        if (type != null) {
            config.setKeyStoreType(context.resolveExpressions(type).asString());
        }
        if (url != null) {
            try {
                config.setKeyStoreURL(context.resolveExpressions(url).asString());
            }
            catch (Exception e) {
                throw SecurityLogger.ROOT_LOGGER.runtimeException(e);
            }
        }
        if (provider != null) {
            config.setKeyStoreProvider(context.resolveExpressions(provider).asString());
        }
        if (providerArgument != null) {
            config.setKeyStoreProviderArgument(context.resolveExpressions(providerArgument).asString());
        }
    }

    private void processKeyManager(OperationContext context, ModelNode node, String name, KeyManagerConfig config) throws OperationFailedException {
        ModelNode algorithm = this.peek(node, name, "algorithm");
        ModelNode provider = this.peek(node, name, "provider");
        if (algorithm != null) {
            config.setKeyManagerFactoryAlgorithm(context.resolveExpressions(algorithm).asString());
        }
        if (provider != null) {
            config.setKeyManagerFactoryProvider(context.resolveExpressions(provider).asString());
        }
    }

    private AppConfigurationEntry.LoginModuleControlFlag getControlFlag(String flag) {
        switch (ModuleFlag.valueOf(flag.toUpperCase(Locale.ENGLISH))) {
            case SUFFICIENT: {
                return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            }
            case OPTIONAL: {
                return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
            case REQUISITE: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            }
        }
        return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
    }

    static String getAuthenticationCacheType(ModelNode node) {
        String type = null;
        if (node.hasDefined("cache-type")) {
            type = node.get("cache-type").asString();
        }
        return type;
    }

    private static interface KeyManagerConfig {
        public void setKeyManagerFactoryAlgorithm(String var1);

        public void setKeyManagerFactoryProvider(String var1);
    }

    private static interface KeyStoreConfig {
        public void setKeyStorePassword(String var1) throws Exception;

        public void setKeyStoreType(String var1);

        public void setKeyStoreURL(String var1) throws IOException;

        public void setKeyStoreProvider(String var1);

        public void setKeyStoreProviderArgument(String var1);
    }

    private static interface LoginModuleContainer {
        public void addAppConfigurationEntry(AppConfigurationEntry var1);
    }
}

