/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.dmr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleIdentifier;

public class ModelNodes {
    public static String asString(ModelNode value) {
        return ModelNodes.asString(value, null);
    }

    public static String asString(ModelNode value, String defaultValue) {
        return value.isDefined() ? value.asString() : defaultValue;
    }

    public static float asFloat(ModelNode value) {
        return Double.valueOf(value.asDouble()).floatValue();
    }

    public static float asFloat(ModelNode value, float defaultValue) {
        return Double.valueOf(value.asDouble((double)defaultValue)).floatValue();
    }

    public static <E extends Enum<E>> E asEnum(ModelNode value, Class<E> targetClass) {
        return ModelNodes.asEnum(value, targetClass, null);
    }

    public static <E extends Enum<E>> E asEnum(ModelNode value, Class<E> targetClass, E defaultValue) {
        return value.isDefined() ? Enum.valueOf(targetClass, value.asString()) : defaultValue;
    }

    public static ModuleIdentifier asModuleIdentifier(ModelNode value) {
        return ModelNodes.asModuleIdentifier(value, null);
    }

    public static ModuleIdentifier asModuleIdentifier(ModelNode value, ModuleIdentifier defaultValue) {
        return value.isDefined() ? ModuleIdentifier.fromString((String)value.asString()) : defaultValue;
    }

    public static List<Property> asPropertyList(ModelNode value) {
        return value.isDefined() ? value.asPropertyList() : Collections.emptyList();
    }

    public static List<String> asStringList(ModelNode value) {
        if (!value.isDefined()) {
            return Collections.emptyList();
        }
        List nodes = value.asList();
        ArrayList<String> result = new ArrayList<String>(nodes.size());
        for (ModelNode node : value.asList()) {
            result.add(node.asString());
        }
        return result;
    }

    public static Properties asProperties(ModelNode value) {
        Properties properties = new Properties();
        for (Property property : ModelNodes.asPropertyList(value)) {
            properties.setProperty(property.getName(), property.getValue().asString());
        }
        return properties;
    }

    private ModelNodes() {
    }
}

