/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;

public class ConfigurationHelper {
    public static String getStringProperty(String propName, String def, Map<String, Object> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (!(prop instanceof String)) {
            return prop.toString();
        }
        return (String)prop;
    }

    public static int getIntProperty(String propName, int def, Map<String, Object> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (prop instanceof String) {
            return Integer.valueOf((String)prop);
        }
        if (!(prop instanceof Number)) {
            ActiveMQClientLogger.LOGGER.propertyNotInteger(propName, prop.getClass().getName());
            return def;
        }
        return ((Number)prop).intValue();
    }

    public static long getLongProperty(String propName, long def, Map<String, Object> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (prop instanceof String) {
            return Long.valueOf((String)prop);
        }
        if (!(prop instanceof Number)) {
            ActiveMQClientLogger.LOGGER.propertyNotLong(propName, prop.getClass().getName());
            return def;
        }
        return ((Number)prop).longValue();
    }

    public static boolean getBooleanProperty(String propName, boolean def, Map<String, Object> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (prop instanceof String) {
            return Boolean.valueOf((String)prop);
        }
        if (!(prop instanceof Boolean)) {
            ActiveMQClientLogger.LOGGER.propertyNotBoolean(propName, prop.getClass().getName());
            return def;
        }
        return (Boolean)prop;
    }

    public static Set<String> checkKeys(Set<String> allowableKeys, Set<String> keys) {
        HashSet<String> invalid = new HashSet<String>();
        for (String key : keys) {
            if (allowableKeys.contains(key)) continue;
            invalid.add(key);
        }
        return invalid;
    }

    public static Set<String> checkKeysExist(Set<String> requiredKeys, Set<String> keys) {
        HashSet<String> invalid = new HashSet<String>(requiredKeys);
        for (String key : keys) {
            if (!requiredKeys.contains(key)) continue;
            invalid.remove(key);
        }
        return invalid;
    }

    public static String stringSetToCommaListString(Set<String> invalid) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String key : invalid) {
            sb.append(key);
            if (count != invalid.size() - 1) {
                sb.append(", ");
            }
            ++count;
        }
        return sb.toString();
    }

    public static String getPasswordProperty(String propName, String def, Map<String, Object> props, String defaultMaskPassword, String defaultPasswordCodec) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        String value = prop.toString();
        Boolean useMask = (Boolean)props.get(defaultMaskPassword);
        if (useMask == null || !useMask.booleanValue()) {
            return value;
        }
        String classImpl = (String)props.get(defaultPasswordCodec);
        if (classImpl == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.noCodec();
        }
        SensitiveDataCodec codec = null;
        try {
            codec = PasswordMaskingUtil.getCodec((String)classImpl);
        }
        catch (ActiveMQException e1) {
            throw ActiveMQClientMessageBundle.BUNDLE.failedToGetDecoder((Exception)((Object)e1));
        }
        try {
            return (String)codec.decode((Object)value);
        }
        catch (Exception e) {
            throw ActiveMQClientMessageBundle.BUNDLE.errordecodingPassword(e);
        }
    }
}

