/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LongBitSet;

public final class DocValuesRewriteMethod
extends MultiTermQuery.RewriteMethod {
    @Override
    public Query rewrite(IndexReader reader, MultiTermQuery query) {
        ConstantScoreQuery result = new ConstantScoreQuery(new MultiTermQueryDocValuesWrapper(query));
        result.setBoost(query.getBoost());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return 641;
    }

    static class MultiTermQueryDocValuesWrapper
    extends Query {
        protected final MultiTermQuery query;

        protected MultiTermQueryDocValuesWrapper(MultiTermQuery query) {
            this.query = query;
        }

        @Override
        public String toString(String field) {
            return this.query.toString(field);
        }

        @Override
        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass().equals(o.getClass())) {
                MultiTermQueryDocValuesWrapper that = (MultiTermQueryDocValuesWrapper)o;
                return this.query.equals(that.query) && this.getBoost() == that.getBoost();
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(this.getClass(), this.query, Float.valueOf(this.getBoost()));
        }

        public final String getField() {
            return this.query.getField();
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            return new RandomAccessWeight(this){

                @Override
                protected Bits getMatchingDocs(final LeafReaderContext context) throws IOException {
                    final SortedSetDocValues fcsi = DocValues.getSortedSet(context.reader(), MultiTermQueryDocValuesWrapper.this.query.field);
                    TermsEnum termsEnum = MultiTermQueryDocValuesWrapper.this.query.getTermsEnum(new Terms(){

                        @Override
                        public TermsEnum iterator() {
                            return fcsi.termsEnum();
                        }

                        @Override
                        public long getSumTotalTermFreq() {
                            return -1L;
                        }

                        @Override
                        public long getSumDocFreq() {
                            return -1L;
                        }

                        @Override
                        public int getDocCount() {
                            return -1;
                        }

                        @Override
                        public long size() {
                            return -1L;
                        }

                        @Override
                        public boolean hasFreqs() {
                            return false;
                        }

                        @Override
                        public boolean hasOffsets() {
                            return false;
                        }

                        @Override
                        public boolean hasPositions() {
                            return false;
                        }

                        @Override
                        public boolean hasPayloads() {
                            return false;
                        }
                    });
                    assert (termsEnum != null);
                    if (termsEnum.next() == null) {
                        return null;
                    }
                    final LongBitSet termSet = new LongBitSet(fcsi.getValueCount());
                    do {
                        long ord;
                        if ((ord = termsEnum.ord()) < 0L) continue;
                        termSet.set(ord);
                    } while (termsEnum.next() != null);
                    return new Bits(){

                        @Override
                        public boolean get(int doc) {
                            fcsi.setDocument(doc);
                            long ord = fcsi.nextOrd();
                            while (ord != -1L) {
                                if (termSet.get(ord)) {
                                    return true;
                                }
                                ord = fcsi.nextOrd();
                            }
                            return false;
                        }

                        @Override
                        public int length() {
                            return context.reader().maxDoc();
                        }
                    };
                }
            };
        }
    }
}

