/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class EnhancedSyntaxSupport {
    static final Pattern ENHANCED_SYNTAX_PATTERN = Pattern.compile("(.*[\\.\\[\\]].*)");
    static final Pattern BRACKETS_PATTERN = Pattern.compile("(.*)\\[(-?\\d+)\\]");
    static final Pattern EXTRACT_NAME_PATTERN = Pattern.compile("^(.*?)[\\.\\[].*");

    EnhancedSyntaxSupport() {
    }

    static boolean containsEnhancedSyntax(String attributeName, ImmutableManagementResourceRegistration registry) {
        return registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName) == null && ENHANCED_SYNTAX_PATTERN.matcher(attributeName).matches();
    }

    static String extractAttributeName(String expression) {
        Matcher matcher = EXTRACT_NAME_PATTERN.matcher(expression);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return expression;
    }

    static ModelNode resolveEnhancedSyntax(String attributeExpression, ModelNode model) throws OperationFailedException {
        ModelNode result = model;
        for (String part : attributeExpression.split("\\.")) {
            Matcher matcher = BRACKETS_PATTERN.matcher(part);
            if (matcher.matches()) {
                ModelNode list;
                String attribute = matcher.group(1);
                int index = Integer.parseInt(matcher.group(2));
                ModelNode modelNode = list = attribute.isEmpty() ? result : result.get(attribute);
                if (list.isDefined() && list.getType() == ModelType.LIST && index >= 0) {
                    result = list.get(index);
                    continue;
                }
                if (index < 0) {
                    throw ControllerLogger.MGMT_OP_LOGGER.couldNotResolveExpressionIndex(attributeExpression, index);
                }
                throw ControllerLogger.MGMT_OP_LOGGER.couldNotResolveExpressionList(attributeExpression);
            }
            if (result.has(part)) {
                result = result.get(part);
                continue;
            }
            throw ControllerLogger.MGMT_OP_LOGGER.couldNotResolveExpression(attributeExpression);
        }
        return result;
    }

    static ModelNode updateWithEnhancedSyntax(String attributeExpression, ModelNode oldValue, ModelNode newValue) throws OperationFailedException {
        ModelNode result = oldValue;
        for (String part : attributeExpression.split("\\.")) {
            Matcher matcher = BRACKETS_PATTERN.matcher(part);
            if (matcher.matches()) {
                ModelNode list;
                String attribute = matcher.group(1);
                int index = Integer.parseInt(matcher.group(2));
                ModelNode modelNode = list = attribute.isEmpty() ? result : result.get(attribute);
                if (index < 0) {
                    result = list.add();
                    continue;
                }
                if (list.isDefined() && list.getType() == ModelType.LIST) {
                    result = list.get(index);
                    continue;
                }
                throw ControllerLogger.MGMT_OP_LOGGER.couldNotResolveExpressionList(attributeExpression);
            }
            if (!result.isDefined() || result.getType() == ModelType.OBJECT) {
                result = result.get(part);
                continue;
            }
            throw ControllerLogger.MGMT_OP_LOGGER.couldNotResolveExpression(attributeExpression);
        }
        result.set(newValue);
        return oldValue;
    }
}

