/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueGeometry
extends Value {
    private final Geometry geometry;

    private ValueGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public static ValueGeometry getFromGeometry(Object object) {
        return ValueGeometry.get((Geometry)object);
    }

    private static ValueGeometry get(Geometry geometry) {
        return (ValueGeometry)Value.cache(new ValueGeometry(geometry));
    }

    public static ValueGeometry get(String string) {
        return (ValueGeometry)Value.cache(new ValueGeometry(ValueGeometry.fromWKT(string)));
    }

    public static ValueGeometry get(byte[] byArray) {
        return (ValueGeometry)Value.cache(new ValueGeometry(ValueGeometry.fromWKB(byArray)));
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public boolean intersects(ValueGeometry valueGeometry) {
        return this.geometry.intersects(valueGeometry.getGeometry());
    }

    public Value intersection(ValueGeometry valueGeometry) {
        return ValueGeometry.get(this.geometry.intersection(valueGeometry.geometry));
    }

    public Value union(ValueGeometry valueGeometry) {
        return ValueGeometry.get(this.geometry.union(valueGeometry.geometry));
    }

    @Override
    public int getType() {
        return 22;
    }

    @Override
    public String getSQL() {
        return StringUtils.quoteStringSQL(this.toWKT());
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        Geometry geometry = ((ValueGeometry)value).geometry;
        return this.geometry.compareTo((Object)geometry);
    }

    @Override
    public String getString() {
        return this.toWKT();
    }

    @Override
    public long getPrecision() {
        return this.toWKT().length();
    }

    @Override
    public int hashCode() {
        return this.geometry.hashCode();
    }

    @Override
    public Object getObject() {
        return this.geometry;
    }

    @Override
    public byte[] getBytes() {
        return this.toWKB();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setObject(n, this.geometry);
    }

    @Override
    public int getDisplaySize() {
        return this.toWKT().length();
    }

    @Override
    public int getMemory() {
        return this.toWKB().length * 20 + 24;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueGeometry && this.geometry.equals(((ValueGeometry)object).geometry);
    }

    public String toWKT() {
        WKTWriter wKTWriter = new WKTWriter();
        return wKTWriter.write(this.geometry);
    }

    public byte[] toWKB() {
        WKBWriter wKBWriter = new WKBWriter();
        return wKBWriter.write(this.geometry);
    }

    private static Geometry fromWKT(String string) {
        WKTReader wKTReader = new WKTReader();
        try {
            return wKTReader.read(string);
        }
        catch (ParseException parseException) {
            throw DbException.convert(parseException);
        }
    }

    private static Geometry fromWKB(byte[] byArray) {
        WKBReader wKBReader = new WKBReader();
        try {
            return wKBReader.read(byArray);
        }
        catch (ParseException parseException) {
            throw DbException.convert(parseException);
        }
    }
}

