/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import java.io.ObjectStreamException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTargetBuilder;
import org.jboss.weld.manager.api.WeldInjectionTargetFactory;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.ForwardingBeanManager;
import org.jboss.weld.util.reflection.Reflections;

public class BeanManagerProxy
extends ForwardingBeanManager
implements WeldManager {
    private static final String GET_BEANS_METHOD_NAME = "getBeans()";
    private static final long serialVersionUID = -6990849486568169846L;
    private final BeanManagerImpl manager;
    private volatile transient Container container;
    private final boolean nonPortableMode;

    public BeanManagerProxy(BeanManagerImpl manager) {
        this.manager = manager;
        this.nonPortableMode = ((WeldConfiguration)manager.getServices().get(WeldConfiguration.class)).getBooleanProperty(ConfigurationKey.NON_PORTABLE_MODE);
    }

    public BeanManagerImpl delegate() {
        return this.manager;
    }

    @Override
    public Object getReference(Bean<?> bean, Type beanType, CreationalContext<?> ctx) {
        this.checkContainerState("getReference()", ContainerState.VALIDATED);
        return super.getReference(bean, beanType, ctx);
    }

    @Override
    public Object getInjectableReference(InjectionPoint ij, CreationalContext<?> ctx) {
        this.checkContainerState("getInjectableReference()", ContainerState.VALIDATED);
        return super.getInjectableReference(ij, ctx);
    }

    @Override
    public Set<Bean<?>> getBeans(Type beanType, Annotation ... qualifiers) {
        this.checkContainerState(GET_BEANS_METHOD_NAME);
        return super.getBeans(beanType, qualifiers);
    }

    @Override
    public Set<Bean<?>> getBeans(String name) {
        this.checkContainerState(GET_BEANS_METHOD_NAME);
        return super.getBeans(name);
    }

    @Override
    public Bean<?> getPassivationCapableBean(String id) {
        this.checkContainerState("getPassivationCapableBean()");
        return super.getPassivationCapableBean(id);
    }

    @Override
    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        this.checkContainerState("resolve()");
        return super.resolve(beans);
    }

    @Override
    public void validate(InjectionPoint injectionPoint) {
        this.checkContainerState("validate()");
        super.validate(injectionPoint);
    }

    @Override
    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... qualifiers) {
        this.checkContainerState("resolveObserverMethods()");
        return super.resolveObserverMethods(event, qualifiers);
    }

    @Override
    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... qualifiers) {
        this.checkContainerState("resolveDecorators()");
        return super.resolveDecorators(types, qualifiers);
    }

    @Override
    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        this.checkContainerState("resolveInterceptors()");
        return super.resolveInterceptors(type, interceptorBindings);
    }

    public WeldManager createActivity() {
        return this.delegate().createActivity();
    }

    public WeldManager setCurrent(Class<? extends Annotation> scopeType) {
        return this.delegate().setCurrent((Class)scopeType);
    }

    public <T> InjectionTarget<T> createInjectionTarget(EjbDescriptor<T> descriptor) {
        return this.delegate().createInjectionTarget(descriptor);
    }

    public <T> Bean<T> getBean(EjbDescriptor<T> descriptor) {
        return this.delegate().getBean((EjbDescriptor)descriptor);
    }

    public <T> EjbDescriptor<T> getEjbDescriptor(String ejbName) {
        return this.delegate().getEjbDescriptor(ejbName);
    }

    public ServiceRegistry getServices() {
        return this.delegate().getServices();
    }

    public WeldManager getCurrent() {
        return this.delegate().getCurrent();
    }

    public <X> InjectionTarget<X> fireProcessInjectionTarget(AnnotatedType<X> type) {
        return this.delegate().fireProcessInjectionTarget(type);
    }

    public <X> InjectionTarget<X> fireProcessInjectionTarget(AnnotatedType<X> annotatedType, InjectionTarget<X> injectionTarget) {
        return this.delegate().fireProcessInjectionTarget(annotatedType, injectionTarget);
    }

    public String getId() {
        return this.delegate().getId();
    }

    public Instance<Object> instance() {
        return this.delegate().instance();
    }

    public Bean<?> getPassivationCapableBean(BeanIdentifier identifier) {
        return this.delegate().getPassivationCapableBean(identifier);
    }

    public <T> WeldInjectionTargetBuilder<T> createInjectionTargetBuilder(AnnotatedType<T> type) {
        return this.delegate().createInjectionTargetBuilder(type);
    }

    public <T> WeldInjectionTargetFactory<T> getInjectionTargetFactory(AnnotatedType<T> annotatedType) {
        return this.delegate().getInjectionTargetFactory(annotatedType);
    }

    public <T> WeldCreationalContext<T> createCreationalContext(Contextual<T> contextual) {
        return this.delegate().createCreationalContext((Contextual)contextual);
    }

    protected Object readResolve() throws ObjectStreamException {
        return new BeanManagerProxy(this.manager);
    }

    private void checkContainerState(String methodName, ContainerState minimalState) {
        ContainerState state;
        if (this.nonPortableMode) {
            return;
        }
        if (this.container == null) {
            this.container = Container.instance(this.manager);
        }
        if (ContainerState.SHUTDOWN.equals((Object)(state = this.container.getState()))) {
            throw BeanManagerLogger.LOG.methodNotAvailableAfterShutdown(methodName);
        }
        if (state.compareTo(minimalState) < 0) {
            throw BeanManagerLogger.LOG.methodNotAvailableDuringInitialization(methodName);
        }
    }

    private void checkContainerState(String methodName) {
        this.checkContainerState(methodName, ContainerState.DISCOVERED);
    }

    public static BeanManagerImpl unwrap(BeanManager manager) {
        BeanManagerImpl instance = BeanManagerProxy.tryUnwrap(manager);
        if (instance == null) {
            throw new IllegalArgumentException("Unknown BeanManager " + manager);
        }
        return instance;
    }

    public static BeanManagerImpl tryUnwrap(Object instance) {
        if (instance instanceof ForwardingBeanManager) {
            instance = ((ForwardingBeanManager)Reflections.cast(instance)).delegate();
        }
        if (instance instanceof BeanManagerImpl) {
            return (BeanManagerImpl)instance;
        }
        return null;
    }

    public BeanManagerImpl unwrap() {
        return this.delegate();
    }
}

