/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.extension.LocalJMXAttributes;
import org.hawkular.agent.monitor.extension.MonitorServiceAddStepHandler;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.wildfly.log.AgentLoggers;
import org.hawkular.agent.wildfly.log.MsgLogger;
import org.hawkular.agent.wildfly.util.Util;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class LocalJMXAdd
extends MonitorServiceAddStepHandler {
    private static final MsgLogger log = AgentLoggers.getLogger(LocalJMXAdd.class);
    public static final LocalJMXAdd INSTANCE = new LocalJMXAdd();

    private LocalJMXAdd() {
        super(LocalJMXAttributes.ATTRIBUTES);
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            return;
        }
        MonitorService monitorService = this.getMonitorService(context);
        if (monitorService == null) {
            return;
        }
        AgentCoreEngineConfiguration config = Util.getMonitorServiceConfiguration(context);
        String newEndpointName = context.getCurrentAddressValue();
        AgentCoreEngineConfiguration.EndpointConfiguration endpointConfig = (AgentCoreEngineConfiguration.EndpointConfiguration)config.getJmxConfiguration().getEndpoints().get(newEndpointName);
        if (endpointConfig.isEnabled()) {
            ProtocolServices newServices = monitorService.createProtocolServicesBuilder().jmxProtocolService(config.getJmxConfiguration()).build();
            EndpointService endpointService = (EndpointService)newServices.getJmxProtocolService().getEndpointServices().get(newEndpointName);
            ProtocolService jmxService = monitorService.getProtocolServices().getJmxProtocolService();
            jmxService.add(endpointService);
        }
    }
}

