/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.wildfly.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.hawkular.agent.monitor.extension.MonitorServiceRestartParentAttributeHandler;
import org.hawkular.inventory.api.Log;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.naming.ImmediateManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceController;

public class WildflyCompatibilityUtils {
    public static InetAddress outboundSocketBindingGetResolvedDestinationAddress(OutboundSocketBinding serverBinding) throws UnknownHostException {
        try {
            return serverBinding.getResolvedDestinationAddress();
        }
        catch (NoSuchMethodError _nsme) {
            return serverBinding.getDestinationAddress();
        }
    }

    public static void subsystemSetHostCapable(SubsystemRegistration subsystem) {
        try {
            subsystem.setHostCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static ManagedReferenceFactory getImmediateManagedReferenceFactory(Object jndiObject) {
        try {
            return new ImmediateManagedReferenceFactory(jndiObject);
        }
        catch (NoClassDefFoundError _ncdfe) {
            return new EAP6ImmediateManagedReferenceFactory(jndiObject);
        }
    }

    public static Injector<ManagedReferenceFactory> getManagedObjectInjectorFromBinderService(BinderService binderService) {
        try {
            return binderService.getManagedObjectInjector();
        }
        catch (NoSuchMethodError _nsme) {
            try {
                Method getManagedObjectInjectorMethod = BinderService.class.getMethod("getManagedObjectInjector", new Class[0]);
                return (Injector)getManagedObjectInjectorMethod.invoke((Object)binderService, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Injector<ServiceBasedNamingStore> getNamingStoreInjectorFromBinderService(BinderService binderService) {
        try {
            return binderService.getNamingStoreInjector();
        }
        catch (NoSuchMethodError _nsme) {
            try {
                Method getManagedObjectInjectorMethod = BinderService.class.getMethod("getNamingStoreInjector", new Class[0]);
                return (Injector)getManagedObjectInjectorMethod.invoke((Object)binderService, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static PathAddress getCurrentAddress(OperationContext context, ModelNode operation) {
        try {
            return context.getCurrentAddress();
        }
        catch (NoSuchMethodError _nsme) {
            return PathAddress.pathAddress((ModelNode)operation.require("address"));
        }
    }

    public static String getCurrentAddressValue(OperationContext context, ModelNode operation) {
        try {
            return context.getCurrentAddressValue();
        }
        catch (NoSuchMethodError _nsme) {
            return PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        }
    }

    public static void operationContextStepCompleted(OperationContext context) {
        block2: {
            Method stepCompletedMethod = null;
            try {
                stepCompletedMethod = OperationContext.class.getMethod("stepCompleted", new Class[0]);
                stepCompletedMethod.invoke((Object)context, new Object[0]);
            }
            catch (ReflectiveOperationException roe) {
                if (stepCompletedMethod == null) break block2;
                Log.LOGGER.warn((Object)"We couldn't execute stepCompleted", (Throwable)roe);
            }
        }
    }

    public static class EAP6MonitorServiceRestartParentAttributeHandler
    extends MonitorServiceRestartParentAttributeHandler {
        public EAP6MonitorServiceRestartParentAttributeHandler(AttributeDefinition ... definitions) {
            super(definitions);
        }

        public EAP6MonitorServiceRestartParentAttributeHandler(Collection<AttributeDefinition> definitions) {
            super(definitions.toArray(new AttributeDefinition[definitions.size()]));
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            this.recreateParentService(context, parentAddress, parentModel);
        }
    }

    public static class AbstractAddStepHandler
    extends org.jboss.as.controller.AbstractAddStepHandler {
        public AbstractAddStepHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            this.performRuntime(context, operation, model);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        }
    }

    private static class EAP6ImmediateManagedReference
    implements ManagedReference {
        private final Object instance;

        public EAP6ImmediateManagedReference(Object instance) {
            this.instance = instance;
        }

        public void release() {
        }

        public Object getInstance() {
            return this.instance;
        }
    }

    private static class EAP6ImmediateManagedReferenceFactory
    implements ManagedReferenceFactory {
        private final ManagedReference reference;

        public EAP6ImmediateManagedReferenceFactory(Object instance) {
            this.reference = new EAP6ImmediateManagedReference(instance);
        }

        public ManagedReference getReference() {
            return this.reference;
        }
    }
}

