/*
 * Decompiled with CFR 0.152.
 */
package org.jipijapa.event.impl.internal;

import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.cache.spi.Wrapper;
import org.jipijapa.event.spi.EventListener;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class Notification {
    private static final CopyOnWriteArrayList<EventListener> eventListeners = new CopyOnWriteArrayList();

    public static void add(EventListener eventListener) {
        eventListeners.add(eventListener);
    }

    public static void remove(EventListener eventListener) {
        eventListeners.remove(eventListener);
    }

    public static void beforeEntityManagerFactoryCreate(Classification cacheType, PersistenceUnitMetadata persistenceUnitMetadata) {
        for (EventListener eventListener : eventListeners) {
            eventListener.beforeEntityManagerFactoryCreate(cacheType, persistenceUnitMetadata);
        }
    }

    public static void afterEntityManagerFactoryCreate(Classification cacheType, PersistenceUnitMetadata persistenceUnitMetadata) {
        for (EventListener eventListener : eventListeners) {
            eventListener.afterEntityManagerFactoryCreate(cacheType, persistenceUnitMetadata);
        }
    }

    public static Wrapper startCache(Classification cacheType, Properties properties) throws Exception {
        Wrapper result = null;
        for (EventListener eventListener : eventListeners) {
            Wrapper value = eventListener.startCache(cacheType, properties);
            if (value == null || result != null) continue;
            result = value;
        }
        return result;
    }

    public static void addCacheDependencies(Classification cacheType, Properties properties) {
        for (EventListener eventListener : eventListeners) {
            eventListener.addCacheDependencies(cacheType, properties);
        }
    }

    public static void stopCache(Classification cacheType, Wrapper wrapper, boolean skipStop) {
        for (EventListener eventListener : eventListeners) {
            eventListener.stopCache(cacheType, wrapper, skipStop);
        }
    }
}

