/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.cache;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedAttribute;
import org.apache.cxf.management.annotation.ManagedResource;

@ManagedResource
public class MemoryIdentityCacheStatistics
implements ManagedComponent {
    private static final Logger LOG = LogUtils.getL7dLogger(MemoryIdentityCacheStatistics.class);
    private long cacheMiss;
    private long cacheHit;
    private ObjectName objectName;

    public MemoryIdentityCacheStatistics() {
    }

    public MemoryIdentityCacheStatistics(Bus bus, ManagedComponent parent) {
        InstrumentationManager im;
        if (bus != null && (im = (InstrumentationManager)bus.getExtension(InstrumentationManager.class)) != null) {
            try {
                StringBuilder buffer = new StringBuilder();
                ObjectName pname = parent.getObjectName();
                String pn = pname.getKeyProperty("name");
                String pt = pname.getKeyProperty("type");
                buffer.append("org.apache.cxf").append(':').append("bus.id").append('=').append(bus.getId()).append(',').append(pt).append('=').append(pn).append(',').append("type").append('=').append("MemoryIdentityCacheStatistics").append(',').append("name").append('=').append("MemoryIdentityCacheStatistics-" + System.identityHashCode(this));
                this.objectName = new ObjectName(buffer.toString());
                im.register((ManagedComponent)this);
            }
            catch (JMException e) {
                LOG.log(Level.WARNING, "Registering MemoryIdentityCacheStatistics failed.", e);
            }
        }
    }

    @ManagedAttribute
    public synchronized long getCacheMiss() {
        return this.cacheMiss;
    }

    @ManagedAttribute
    public synchronized long getCacheHit() {
        return this.cacheHit;
    }

    protected synchronized void increaseCacheHit() {
        ++this.cacheHit;
    }

    protected synchronized void increaseCacheMiss() {
        ++this.cacheMiss;
    }

    public ObjectName getObjectName() throws JMException {
        return this.objectName;
    }
}

