/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.agent.monitor.inventory.ID;

public abstract class IDObject {
    private final ID id;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private long persistedTime = 0L;

    public IDObject(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.id = new ID(id);
    }

    public IDObject(ID id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.id = id;
    }

    public ID getID() {
        return this.id;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void addProperty(String name, Object value) {
        if (value != null) {
            this.properties.put(name, value);
        } else {
            this.removeProperty(name);
        }
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public long getPersistedTime() {
        return this.persistedTime;
    }

    public void setPersistedTime(long timestamp) {
        this.persistedTime = timestamp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IDObject)) {
            return false;
        }
        ID thisID = this.id;
        ID thatID = ((IDObject)obj).id;
        return thisID.equals(thatID);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.format("%s[id=%s][props=%s]", this.getClass().getSimpleName(), this.getID(), this.getProperties());
    }
}

