/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.platform;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Name;

public interface Constants {
    public static final String MACHINE_ID = "Machine Id";
    public static final String CONTAINER_ID = "Container Id";

    public static enum PlatformMetricType {
        OS_SYS_CPU_LOAD(PlatformResourceType.OPERATING_SYSTEM, "System CPU Load"),
        OS_SYS_LOAD_AVG(PlatformResourceType.OPERATING_SYSTEM, "System Load Average"),
        OS_PROCESS_COUNT(PlatformResourceType.OPERATING_SYSTEM, "Process Count"),
        FILE_STORE_USABLE_SPACE(PlatformResourceType.FILE_STORE, "Usable Space"),
        FILE_STORE_TOTAL_SPACE(PlatformResourceType.FILE_STORE, "Total Space"),
        MEMORY_AVAILABLE(PlatformResourceType.MEMORY, "Available Memory"),
        MEMORY_TOTAL(PlatformResourceType.MEMORY, "Total Memory"),
        PROCESSOR_CPU_USAGE(PlatformResourceType.PROCESSOR, "CPU Usage"),
        POWER_SOURCE_REMAINING_CAPACITY(PlatformResourceType.POWER_SOURCE, "Remaining Capacity"),
        POWER_SOURCE_TIME_REMAINING(PlatformResourceType.POWER_SOURCE, "Time Remaining");

        private final PlatformResourceType resourceType;
        private final ID metricTypeId;
        private final Name metricTypeName;

        private PlatformMetricType(PlatformResourceType resourceType, String name) {
            this.resourceType = resourceType;
            this.metricTypeId = new ID(resourceType.getResourceTypeId().getIDString() + "_" + name);
            this.metricTypeName = new Name(name);
        }

        public PlatformResourceType getResourceType() {
            return this.resourceType;
        }

        public ID getMetricTypeId() {
            return this.metricTypeId;
        }

        public Name getMetricTypeName() {
            return this.metricTypeName;
        }

        public static Collection<PlatformMetricType> getPlatformMetricTypes(PlatformResourceType type) {
            return Collections.unmodifiableList(Arrays.asList(PlatformMetricType.values()).stream().filter(t -> t.getResourceType() == type).collect(Collectors.toList()));
        }
    }

    public static enum PlatformResourceType {
        OPERATING_SYSTEM("Operating System"),
        FILE_STORE("File Store"),
        MEMORY("Memory"),
        PROCESSOR("Processor"),
        POWER_SOURCE("Power Source");

        private final ID resourceTypeId;
        private final Name resourceTypeName;
        private Collection<PlatformMetricType> metricTypes;
        private Collection<ID> metricTypeIds;

        private PlatformResourceType(String name) {
            this.resourceTypeId = new ID("Platform_" + name);
            this.resourceTypeName = new Name(name);
        }

        public ID getResourceTypeId() {
            return this.resourceTypeId;
        }

        public Name getResourceTypeName() {
            return this.resourceTypeName;
        }

        public Collection<PlatformMetricType> getMetricTypes() {
            if (this.metricTypes == null) {
                this.metricTypes = PlatformMetricType.getPlatformMetricTypes(this);
            }
            return this.metricTypes;
        }

        public Collection<ID> getMetricTypeIds() {
            if (this.metricTypeIds == null) {
                this.metricTypeIds = Collections.unmodifiableList(this.getMetricTypes().stream().map(n -> n.getMetricTypeId()).collect(Collectors.toList()));
            }
            return this.metricTypeIds;
        }
    }
}

