/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.message.impl;

import java.math.BigDecimal;
import java.nio.CharBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.Flow;
import org.apache.qpid.proton.message.MessageFormatException;

class AMQPMessageFormat {
    private static final char START_LIST = '[';
    private static final char DESCRIPTOR_CHAR = '@';
    private static final char SYMBOL_START = ':';
    private static final char QUOTE_CHAR = '\"';
    private static final char START_MAP = '{';
    private static final char END_LIST = ']';
    private static final char END_MAP = '}';
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    AMQPMessageFormat() {
    }

    public String encode(Object o) {
        if (o instanceof Boolean) {
            return this.encodeBoolean((Boolean)o);
        }
        if (o instanceof byte[]) {
            return this.encodeBinary((byte[])o);
        }
        if (o instanceof Number) {
            return this.encodeNumber((Number)o);
        }
        if (o instanceof String) {
            return this.encodeString((String)o);
        }
        if (o instanceof Symbol) {
            return this.encodeSymbol((Symbol)o);
        }
        if (o instanceof List) {
            return this.encodeList((List)o);
        }
        if (o instanceof Map) {
            return this.encodeMap((Map)o);
        }
        if (o instanceof DescribedType) {
            return this.encodeDescribedType((DescribedType)o);
        }
        if (o == null) {
            return "null";
        }
        return null;
    }

    private String encodeBinary(byte[] o) {
        StringBuilder b = new StringBuilder();
        b.append("b\"");
        for (byte x : o) {
            if (x >= 32 && x < 127 && x != 34 && x != 92) {
                b.append((char)x);
                continue;
            }
            b.append("\\x");
            b.append(HEX[x >> 4 & 0xF]);
            b.append(HEX[x & 0xF]);
        }
        b.append('\"');
        return b.toString();
    }

    private String encodeNumber(Number o) {
        if (o instanceof Float || o instanceof Double || o instanceof BigDecimal) {
            DecimalFormat df = new DecimalFormat("############.#######");
            return df.format(o);
        }
        Formatter f = new Formatter();
        return f.format("%d", o.longValue()).toString();
    }

    private String encodeBoolean(boolean o) {
        return o ? "true" : "false";
    }

    private String encodeDescribedType(DescribedType o) {
        StringBuilder b = new StringBuilder();
        b.append('@');
        b.append(this.encode(o.getDescriptor()));
        b.append(' ');
        b.append(this.encode(o.getDescribed()));
        return b.toString();
    }

    private String encodeMap(Map<Object, Object> o) {
        StringBuilder b = new StringBuilder();
        b.append('{');
        boolean first = true;
        for (Map.Entry<Object, Object> e : o.entrySet()) {
            if (first) {
                first = false;
            } else {
                b.append(',');
                b.append(' ');
            }
            b.append(this.encode(e.getKey()));
            b.append('=');
            b.append(this.encode(e.getValue()));
        }
        b.append('}');
        return b.toString();
    }

    private String encodeList(List o) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        boolean first = true;
        for (Object e : o) {
            if (first) {
                first = false;
            } else {
                b.append(',');
                b.append(' ');
            }
            b.append(this.encode(e));
        }
        b.append(']');
        return b.toString();
    }

    private String encodeSymbol(Symbol o) {
        StringBuilder b = new StringBuilder(":");
        String sym = o.toString();
        if (this.needsQuoting(sym)) {
            b.append(this.encodeString(sym));
        } else {
            b.append(sym);
        }
        return b.toString();
    }

    private boolean needsQuoting(String sym) {
        for (char c : sym.toCharArray()) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') continue;
            return true;
        }
        return false;
    }

    private String encodeString(String o) {
        StringBuilder b = new StringBuilder();
        b.append("\"");
        for (char c : o.toCharArray()) {
            if (c == '\\') {
                b.append("\\\\");
                continue;
            }
            if (c == '\n') {
                b.append("\\n");
                continue;
            }
            if (c == '\b') {
                b.append("\\b");
                continue;
            }
            if (c == '\r') {
                b.append("\\r");
                continue;
            }
            if (c == '\t') {
                b.append("\\t");
                continue;
            }
            if (c == '\"') {
                b.append("\\\"");
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                Formatter fmt = new Formatter();
                b.append("\\u");
                b.append(fmt.format("%04x", c));
                continue;
            }
            b.append(c);
        }
        b.append("\"");
        return b.toString();
    }

    public static void main(String[] args) {
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        List<Object> x = Arrays.asList(Symbol.valueOf("hel lo"), "hi", Symbol.valueOf("x"));
        m.put(Symbol.valueOf("ddd"), x);
        m.put("hello", "world");
        Flow flow = new Flow();
        flow.setDrain(true);
        m.put(flow, "wibble");
        AMQPMessageFormat f = new AMQPMessageFormat();
        System.err.println(f.encode(m));
        byte[] data = new byte[]{0, 23, 45, 98, -1, 32, 78, 12, 126, 127, -128, 66, 67, 68};
        System.err.println(f.encodeBinary(data));
        byte[] data2 = (byte[])f.format(f.encode(data));
        System.out.println(Arrays.equals(data, data2));
    }

    public Object format(CharSequence s) {
        return this.readValue(CharBuffer.wrap(s));
    }

    private void skipWhitespace(CharBuffer s) {
        while (s.hasRemaining()) {
            char c = s.get();
            if (Character.isWhitespace(c)) continue;
            s.position(s.position() - 1);
            break;
        }
    }

    private Object readValue(CharBuffer s) {
        this.skipWhitespace(s);
        if (!s.hasRemaining()) {
            throw new MessageFormatException("Expecting a value, but only whitespace found", s);
        }
        char c = s.get(s.position());
        if (Character.isDigit(c) || c == '-') {
            return this.readNumber(s);
        }
        if (c == ':') {
            return this.readSymbol(s);
        }
        if (c == '{') {
            return this.readMap(s);
        }
        if (c == '[') {
            return this.readList(s);
        }
        if (c == 'b') {
            return this.readBinary(s);
        }
        if (c == '@') {
            return this.readDescribedType(s);
        }
        if (c == 't') {
            this.expect(s, "true");
            return Boolean.TRUE;
        }
        if (c == 'f') {
            this.expect(s, "false");
            return Boolean.FALSE;
        }
        if (c == 'n') {
            this.expect(s, "null");
            return null;
        }
        if (c == '\"') {
            return this.readString(s);
        }
        throw new MessageFormatException("Cannot parse message string", s);
    }

    private Object readDescribedType(CharBuffer s) {
        this.expect(s, '@');
        final Object descriptor = this.readValue(s);
        final Object described = this.readValue(s);
        return new DescribedType(){

            @Override
            public Object getDescriptor() {
                return descriptor;
            }

            @Override
            public Object getDescribed() {
                return described;
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof DescribedType && descriptor == null ? ((DescribedType)obj).getDescriptor() == null : (descriptor.equals(((DescribedType)obj).getDescriptor()) && described == null ? ((DescribedType)obj).getDescribed() == null : described.equals(((DescribedType)obj).getDescribed()));
            }

            public String toString() {
                return "@" + descriptor + " " + described;
            }
        };
    }

    private Object readBinary(CharBuffer s) {
        byte[] bytes = new byte[s.remaining()];
        int length = 0;
        this.expect(s, "b\"");
        while (s.hasRemaining()) {
            char c = s.get();
            if (c == '\\') {
                byte val;
                this.expect(s, 'x');
                if (s.remaining() < 2) {
                    throw new MessageFormatException("binary string escaped numeric value not correctly formatted", s);
                }
                c = s.get();
                if (c >= 'a' && c <= 'f') {
                    val = (byte)(16 * (10 + (c - 97)));
                } else if (c >= 'A' && c <= 'F') {
                    val = (byte)(16 * (10 + (c - 65)));
                } else if (c >= '0' && c <= '9') {
                    val = (byte)(16 * (c - 48));
                } else {
                    throw new MessageFormatException("invalid value", s);
                }
                c = s.get();
                if (c >= 'a' && c <= 'f') {
                    val = (byte)(val + (byte)(10 + (c - 97)));
                } else if (c >= 'A' && c <= 'F') {
                    val = (byte)(val + (byte)(10 + (c - 65)));
                } else if (c >= '0' && c <= '9') {
                    val = (byte)(val + (byte)(c - 48));
                } else {
                    throw new MessageFormatException("invalid value", s);
                }
                bytes[length++] = val;
                continue;
            }
            if (c == '\"') {
                byte[] rval = new byte[length];
                System.arraycopy(bytes, 0, rval, 0, length);
                return rval;
            }
            if (c >= '\u0100') continue;
            bytes[length++] = (byte)c;
        }
        throw new MessageFormatException("unterminated binary string", s);
    }

    private Object readList(CharBuffer s) {
        ArrayList<Object> list = new ArrayList<Object>();
        this.expect(s, '[');
        while (s.hasRemaining()) {
            this.skipWhitespace(s);
            char c = s.get(s.position());
            if (c == ']') {
                c = s.get();
                return list;
            }
            if (!list.isEmpty()) {
                this.expect(s, ',');
            }
            list.add(this.readValue(s));
        }
        throw new MessageFormatException("unterminated list", s);
    }

    private Object readMap(CharBuffer s) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        this.expect(s, '{');
        while (s.hasRemaining()) {
            this.skipWhitespace(s);
            char c = s.get(s.position());
            if (c == '}') {
                c = s.get();
                return map;
            }
            if (!map.isEmpty()) {
                this.expect(s, ',');
            }
            Object key = this.readValue(s);
            this.skipWhitespace(s);
            this.expect(s, '=');
            Object value = this.readValue(s);
            map.put(key, value);
        }
        throw new MessageFormatException("unterminated map", s);
    }

    private void expect(CharBuffer s, String t) {
        this.expect(s, t.toCharArray());
    }

    private void expect(CharBuffer s, char ... expect) {
        for (char e : expect) {
            char c = s.get();
            if (c == e) continue;
            throw new IllegalArgumentException("expecting " + expect + " character" + s.toString());
        }
    }

    private Object readSymbol(CharBuffer s) {
        char c = s.get();
        if (c != ':') {
            throw new IllegalArgumentException("expecting @ as first character" + s.toString());
        }
        c = s.get(s.position());
        if (c == '\"') {
            return this.readQuotedSymbol(s);
        }
        return this.readUnquotedSymbol(s);
    }

    private Object readUnquotedSymbol(CharBuffer s) {
        char c;
        StringBuilder b = new StringBuilder();
        while (s.hasRemaining() && !Character.isWhitespace(c = s.get(s.position())) && c != '=' && c != ',') {
            if (c > '\u00ff') {
                throw new MessageFormatException("Illegal character " + c, s);
            }
            s.get();
            b.append(c);
        }
        return Symbol.valueOf(b.toString());
    }

    private Object readQuotedSymbol(CharBuffer s) {
        String str = this.readString(s);
        return Symbol.valueOf(str);
    }

    private String readString(CharBuffer s) {
        this.expect(s, '\"');
        StringBuilder b = new StringBuilder();
        while (s.hasRemaining()) {
            char c = s.get();
            if (c == '\"') {
                return b.toString();
            }
            if (c == '\\') {
                if (!s.hasRemaining()) {
                    throw new MessageFormatException("Unterminated escape", s);
                }
                c = s.get();
                switch (c) {
                    case 'b': {
                        b.append('\b');
                        break;
                    }
                    case 'f': {
                        b.append('\f');
                        break;
                    }
                    case 'n': {
                        b.append('\n');
                        break;
                    }
                    case 'r': {
                        b.append('\r');
                        break;
                    }
                    case 't': {
                        b.append('\t');
                        break;
                    }
                    case '\\': {
                        b.append('\\');
                        break;
                    }
                    case '\"': {
                        b.append('\"');
                        break;
                    }
                    case 'u': {
                        if (s.remaining() < 4) {
                            throw new MessageFormatException("Incorrect format for unicode character", s);
                        }
                        String num = new String(new char[]{s.get(), s.get(), s.get(), s.get()});
                        char u = (char)Integer.parseInt(num, 16);
                        b.append(u);
                        break;
                    }
                    default: {
                        b.append(c);
                        break;
                    }
                }
                continue;
            }
            b.append(c);
        }
        throw new MessageFormatException("unterminated map", s);
    }

    private Object readNumber(CharBuffer s) {
        Number num;
        char c;
        StringBuilder b = new StringBuilder();
        while (s.hasRemaining() && !Character.isWhitespace(c = s.get(s.position())) && c != ']' && c != '}' && c != ',' && c != '=') {
            c = s.get();
            b.append(c);
        }
        String numberString = b.toString();
        if (numberString.contains(".")) {
            num = Double.parseDouble(numberString);
        } else {
            num = Long.parseLong(numberString);
            if (num.longValue() >= Integer.MIN_VALUE && num.longValue() <= Integer.MAX_VALUE) {
                num = num.intValue();
            }
        }
        return num;
    }
}

