/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.jmx;

import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.protocol.ProtocolException;
import org.hawkular.agent.monitor.protocol.jmx.JMXDriver;
import org.hawkular.agent.monitor.protocol.jmx.JMXLocationResolver;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;

public class MBeanServerConnectionJMXDriver
extends JMXDriver {
    private final MBeanServerConnection mbs;

    public MBeanServerConnectionJMXDriver(ProtocolDiagnostics diagnostics, MBeanServerConnection mbs) {
        super(diagnostics);
        this.mbs = mbs;
    }

    @Override
    public Map<JMXNodeLocation, ObjectName> fetchNodes(JMXNodeLocation query) throws ProtocolException {
        try {
            Set<ObjectName> searchResponse;
            Timer.Context timerContext = this.getDiagnostics().getRequestTimer().time();
            Object object = null;
            try {
                searchResponse = this.mbs.queryNames(query.getObjectName(), null);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (timerContext != null) {
                    if (object != null) {
                        try {
                            timerContext.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        timerContext.close();
                    }
                }
            }
            HashMap<JMXNodeLocation, ObjectName> result = new HashMap<JMXNodeLocation, ObjectName>();
            for (ObjectName objectName : searchResponse) {
                JMXNodeLocation location = new JMXNodeLocation(objectName);
                result.put(location, objectName);
            }
            return Collections.unmodifiableMap(result);
        }
        catch (Exception e) {
            this.getDiagnostics().getErrorRate().mark(1L);
            throw new ProtocolException(e);
        }
    }

    @Override
    public boolean attributeExists(AttributeLocation<JMXNodeLocation> location) throws ProtocolException {
        return true;
    }

    @Override
    public Object fetchAttribute(AttributeLocation<JMXNodeLocation> location) throws ProtocolException {
        try {
            Map<JMXNodeLocation, ObjectName> all = this.fetchNodes(location.getLocation());
            if (all.isEmpty()) {
                return null;
            }
            String[] attributeArr = location.getAttribute().split("#", 2);
            String mainAttribute = attributeArr[0];
            String subAttribute = attributeArr.length > 1 ? attributeArr[1] : null;
            ArrayList<Object> results = new ArrayList<Object>(all.size());
            for (Map.Entry<JMXNodeLocation, ObjectName> entry : all.entrySet()) {
                Object value;
                ObjectName objName = entry.getValue();
                try (Timer.Context timerContext = this.getDiagnostics().getRequestTimer().time();){
                    value = this.mbs.getAttribute(objName, mainAttribute);
                }
                if (subAttribute == null) {
                    results.add(value);
                    continue;
                }
                if (value instanceof CompositeData) {
                    CompositeData cd = (CompositeData)value;
                    results.add(cd.get(subAttribute));
                    continue;
                }
                throw new Exception("Not a composite attribute: " + location);
            }
            if (results.size() == 1) {
                return results.get(0);
            }
            return Collections.unmodifiableList(results);
        }
        catch (Exception e) {
            this.getDiagnostics().getErrorRate().mark(1L);
            throw new ProtocolException(e);
        }
    }

    @Override
    public Map<JMXNodeLocation, Object> fetchAttributeAsMap(AttributeLocation<JMXNodeLocation> location) throws ProtocolException {
        if (!new JMXLocationResolver().isMultiTarget(location.getLocation())) {
            Object o = this.fetchAttribute(location);
            return Collections.singletonMap(location.getLocation(), o);
        }
        Map<JMXNodeLocation, ObjectName> nodes = this.fetchNodes(location.getLocation());
        HashMap<JMXNodeLocation, Object> attribsMap = new HashMap<JMXNodeLocation, Object>(nodes.size());
        for (Map.Entry<JMXNodeLocation, ObjectName> entry : nodes.entrySet()) {
            Object o = this.fetchAttribute(new AttributeLocation<JMXNodeLocation>(entry.getKey(), location.getAttribute()));
            attribsMap.put(entry.getKey(), o);
        }
        return Collections.unmodifiableMap(attribsMap);
    }

    @Override
    public Object executeOperation(ObjectName mbeanName, String operationName, Object[] args, Class<?>[] signature) throws Exception {
        String[] signatureAsStrings;
        if (signature == null) {
            signatureAsStrings = new String[]{};
        } else {
            signatureAsStrings = new String[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                signatureAsStrings[i] = signature[i].getName();
            }
        }
        return this.mbs.invoke(mbeanName, operationName, args, signatureAsStrings);
    }
}

