/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service.descriptor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.service.descriptor.JBossServiceConfig;

public final class JBossServiceXmlDescriptor
implements Serializable {
    private static final long serialVersionUID = 3148478338698997486L;
    public static final AttachmentKey<JBossServiceXmlDescriptor> ATTACHMENT_KEY = AttachmentKey.create(JBossServiceXmlDescriptor.class);
    private ControllerMode controllerMode = ControllerMode.PASSIVE;
    private List<JBossServiceConfig> serviceConfigs;

    public List<JBossServiceConfig> getServiceConfigs() {
        return this.serviceConfigs;
    }

    public void setServiceConfigs(List<JBossServiceConfig> serviceConfigs) {
        this.serviceConfigs = serviceConfigs;
    }

    public ControllerMode getControllerMode() {
        return this.controllerMode;
    }

    public void setControllerMode(ControllerMode controllerMode) {
        this.controllerMode = controllerMode;
    }

    public static enum ControllerMode {
        ACTIVE("active"),
        PASSIVE("passive"),
        ON_DEMAND("on demand"),
        NEVER("never");

        private static final Map<String, ControllerMode> MAP;
        private final String value;

        private ControllerMode(String value) {
            this.value = value;
        }

        static ControllerMode of(String value) {
            ControllerMode controllerMode = MAP.get(value);
            return controllerMode == null ? PASSIVE : controllerMode;
        }

        static {
            MAP = new HashMap<String, ControllerMode>();
            for (ControllerMode mode : ControllerMode.values()) {
                MAP.put(mode.value, mode);
            }
        }
    }
}

