/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import io.undertow.servlet.api.Deployment;
import java.util.Iterator;
import java.util.Set;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Host;
import org.wildfly.mod_cluster.undertow.UndertowContext;

public class UndertowHost
implements Host {
    private org.wildfly.extension.undertow.Host host;
    private Engine engine;

    public UndertowHost(org.wildfly.extension.undertow.Host host, Engine engine) {
        this.engine = engine;
        this.host = host;
    }

    public String getName() {
        return this.host.getName();
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Iterable<Context> getContexts() {
        final Iterator deployments = this.host.getDeployments().iterator();
        final Iterator<Context> iterator = new Iterator<Context>(){

            @Override
            public boolean hasNext() {
                return deployments.hasNext();
            }

            @Override
            public Context next() {
                return new UndertowContext((Deployment)deployments.next(), UndertowHost.this);
            }

            @Override
            public void remove() {
                deployments.remove();
            }
        };
        return new Iterable<Context>(){

            @Override
            public Iterator<Context> iterator() {
                return iterator;
            }
        };
    }

    public Set<String> getAliases() {
        return this.host.getAllAliases();
    }

    public Context findContext(String path) {
        String findPath = "".equals(path) ? "/" : path;
        for (Deployment deployment : this.host.getDeployments()) {
            if (!deployment.getDeploymentInfo().getContextPath().equals(findPath)) continue;
            return new UndertowContext(deployment, this);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndertowHost)) {
            return false;
        }
        UndertowHost host = (UndertowHost)object;
        return this.getName().equals(host.getName());
    }

    public int hashCode() {
        return this.host.getName().hashCode();
    }

    public String toString() {
        return this.host.getName();
    }
}

