/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="Data entity contains JSON data and serves a certain \"role\" in the entity it is contained in", parent=Entity.class)
public final class DataEntity
extends Entity {
    public static final SegmentType SEGMENT_TYPE = SegmentType.d;
    private final StructuredData value;

    private DataEntity() {
        this.value = null;
    }

    public DataEntity(CanonicalPath owner, DataRole role, StructuredData value) {
        super(null, owner.extend(SEGMENT_TYPE, role.name()).get());
        this.value = value;
    }

    public DataEntity(CanonicalPath owner, DataRole role, StructuredData value, Map<String, Object> properties) {
        super(owner.extend(SEGMENT_TYPE, role.name()).get(), properties);
        this.value = value;
    }

    public DataEntity(CanonicalPath path, StructuredData value, Map<String, Object> properties) {
        this(path.up(), DataRole.valueOf((String)path.getSegment().getElementId()), value, properties);
    }

    @Override
    public String getName() {
        return this.getRole().name();
    }

    public StructuredData getValue() {
        return this.value;
    }

    public DataRole getRole() {
        return DataRole.valueOf((String)this.getId());
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitData(this, null);
    }

    @ApiModel(value="DataEntityBlueprint")
    public static final class Blueprint<DR extends DataRole>
    extends Entity.Blueprint {
        private static final StructuredData UNDEFINED = StructuredData.get().undefined();
        private final StructuredData value;
        private final DR role;

        public static <R extends DataRole> Builder<R> builder() {
            return new Builder();
        }

        public Blueprint(DR role, StructuredData value, Map<String, Object> properties) {
            this(role, value, properties, null, null);
        }

        public Blueprint(DR role, StructuredData value, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(role.name(), properties, outgoing, incoming);
            if (value == null) {
                value = StructuredData.get().undefined();
            }
            this.role = role;
            this.value = value;
        }

        private Blueprint() {
            this.value = null;
            this.role = null;
        }

        public StructuredData getValue() {
            return this.value == null ? UNDEFINED : this.value;
        }

        public DR getRole() {
            return (DR)(this.role == null ? DataRole.valueOf((String)this.getId()) : this.role);
        }

        @Override
        public String getName() {
            return this.getRole().name();
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitData(this, parameter);
        }

        public static final class Builder<R extends DataRole>
        extends Entity.Blueprint.Builder<Blueprint, Builder<R>> {
            private R role;
            private StructuredData value;

            public Builder<R> withValue(StructuredData value) {
                this.value = value;
                return this;
            }

            public Builder<R> withRole(R role) {
                this.role = role;
                return this;
            }

            @Override
            public Builder<R> withId(String id) {
                return this.withRole(DataRole.valueOf((String)id));
            }

            @Override
            public Blueprint<R> build() {
                if (this.role == null) {
                    throw new NullPointerException("Data entity role not specified.");
                }
                return new Blueprint<R>(this.role, this.value, (Map<String, Object>)this.properties);
            }
        }
    }
}

