/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="Defines the basic properties of all entity types in inventory", subTypes={Environment.class, Entity.class, MetadataPack.class, Tenant.class})
public abstract class Entity
extends AbstractElement {
    private final String name;

    public static Class<?> typeFromSegmentType(SegmentType segmentType) {
        switch (segmentType) {
            case up: {
                return RelativePath.Up.class;
            }
        }
        return Entity.entityTypeFromSegmentType(segmentType);
    }

    public static Class<? extends Entity> entityTypeFromSegmentType(SegmentType segmentType) {
        switch (segmentType) {
            case t: {
                return Tenant.class;
            }
            case e: {
                return Environment.class;
            }
            case f: {
                return Feed.class;
            }
            case m: {
                return Metric.class;
            }
            case mt: {
                return MetricType.class;
            }
            case r: {
                return Resource.class;
            }
            case rt: {
                return ResourceType.class;
            }
            case d: {
                return DataEntity.class;
            }
            case ot: {
                return OperationType.class;
            }
            case mp: {
                return MetadataPack.class;
            }
        }
        throw new IllegalStateException("There is no " + Entity.class.getName() + " type for " + segmentType.getClass().getName() + " '" + segmentType.name() + "'");
    }

    Entity() {
        this.name = null;
    }

    Entity(CanonicalPath path) {
        this(path, null);
    }

    Entity(CanonicalPath path, Map<String, Object> properties) {
        this(null, path, properties);
    }

    public Entity(String name, CanonicalPath path) {
        this(name, path, null);
    }

    Entity(String name, CanonicalPath path, Map<String, Object> properties) {
        super(path, properties);
        this.name = name;
        if (!Entity.segmentTypeFromType(this.getClass()).equals((Object)path.getSegment().getElementType())) {
            throw new IllegalArgumentException("Invalid path specified. Trying to create " + this.getClass().getSimpleName() + " but the path points to " + path.getSegment().getElementType().getSimpleName());
        }
    }

    public String getName() {
        return this.name;
    }

    protected void appendToString(StringBuilder toStringBuilder) {
    }

    public final String toString() {
        StringBuilder bld = new StringBuilder(this.getClass().getSimpleName());
        bld.append("[path='").append(this.getPath()).append('\'');
        this.appendToString(bld);
        bld.append(']');
        return bld.toString();
    }

    public static abstract class Blueprint
    extends AbstractElement.Blueprint {
        private final String id;
        private final String name;
        private final Map<String, Set<CanonicalPath>> outgoing;
        private final Map<String, Set<CanonicalPath>> incoming;

        protected Blueprint() {
            super(null);
            this.id = null;
            this.name = null;
            this.outgoing = null;
            this.incoming = null;
        }

        protected Blueprint(String id, Map<String, Object> properties) {
            this(id, properties, null, null);
        }

        protected Blueprint(String id, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            this(id, null, properties, outgoing, incoming);
        }

        protected Blueprint(String id, String name, Map<String, Object> properties) {
            this(id, name, properties, null, null);
        }

        protected Blueprint(String id, String name, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(properties);
            if (id == null) {
                throw new IllegalArgumentException("id == null");
            }
            this.id = id;
            this.name = name;
            this.outgoing = outgoing == null ? Collections.emptyMap() : Blueprint.copyAsUnmodifiable(outgoing);
            this.incoming = incoming == null ? Collections.emptyMap() : Blueprint.copyAsUnmodifiable(incoming);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Blueprint blueprint = (Blueprint)o;
            return this.id.equals(blueprint.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        private static Map<String, Set<CanonicalPath>> copyAsUnmodifiable(Map<String, Set<CanonicalPath>> map) {
            HashMap ret = new HashMap(map.size());
            map.forEach((k, v) -> ret.put(k, Collections.unmodifiableSet(v)));
            return Collections.unmodifiableMap(ret);
        }

        public static abstract class Builder<Blueprint, This extends Builder<Blueprint, This>>
        extends AbstractElement.Blueprint.Builder<Blueprint, This> {
            protected String id;
            protected String name;
            protected Map<String, Set<CanonicalPath>> outgoing;
            protected Map<String, Set<CanonicalPath>> incoming;

            public This withId(String id) {
                this.id = id;
                return (This)((Builder)this.castThis());
            }

            public This withName(String name) {
                this.name = name;
                return (This)((Builder)this.castThis());
            }

            public This withOutgoingRelationships(Map<String, Set<CanonicalPath>> outgoing) {
                this.outgoing = outgoing;
                return (This)((Builder)this.castThis());
            }

            public This withIncomingRelationships(Map<String, Set<CanonicalPath>> incoming) {
                this.incoming = incoming;
                return (This)((Builder)this.castThis());
            }
        }
    }
}

