/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.security.AccessController;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jgroups.JChannel;
import org.wildfly.extension.messaging.activemq.ActiveMQServerService;
import org.wildfly.extension.messaging.activemq.MessagingServices;

public class JGroupsChannelLocator {
    public JChannel locateChannel(String channelRefName) {
        String[] split = channelRefName.split("/");
        String activeMQServerName = split[0];
        String channelName = split[1];
        ServiceController controller = JGroupsChannelLocator.currentServiceContainer().getService(MessagingServices.getActiveMQServiceName(activeMQServerName));
        ActiveMQServerService service = (ActiveMQServerService)controller.getService();
        return service.getChannels().get(channelName);
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }
}

